/*
 * Decompiled with CFR 0.152.
 */
package javakarol;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javakarol.Roboter;
import javakarol.Welt;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class WeltAnzeige2D
extends JPanel {
    private Welt welt;
    private GraphicsConfiguration gfxConf;
    private BufferedImage zeichenFlaeche;
    private Point weltOrigin2D = new Point(0, 0);
    private Graphics2D gDC;
    private Color hintergrundFarbe = Color.WHITE;
    private int[] fuellFarbe = new int[]{0xCD0000, 0xDCDC00, 205, 52480, 0x3B3B3B};
    private int[] randFarbe = new int[]{0xFF0000, 0xFFFF00, 255, 65280, 0x202020};
    private final int randLinks = 20;
    private final int randOben = 20;
    private final int randUnten = 10;
    private final int fliese = 30;

    public WeltAnzeige2D(Welt welt) {
        this.welt = welt;
        this.gfxConf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        this.zeichenFlaecheVorbereiten();
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createLineBorder(Color.green));
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(this.getMinBreite(), this.getMinHoehe()));
    }

    public int getMinBreite() {
        return this.zeichenFlaeche.getWidth() + 10;
    }

    public int getMinHoehe() {
        return this.zeichenFlaeche.getHeight() + 10;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.zeichenFlaeche, 0, 0, null);
    }

    public void paintToFile(File f, String fileTyp) {
        try {
            ImageIO.write((RenderedImage)this.zeichenFlaeche, fileTyp, f);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected BufferedImage getZeichenflaeche() {
        return this.zeichenFlaeche;
    }

    protected void zeichneWelt() {
        int links = Integer.MAX_VALUE;
        int oben = Integer.MAX_VALUE;
        int rechts = Integer.MIN_VALUE;
        int unten = Integer.MIN_VALUE;
        int a = 1;
        while (a <= this.welt.areaBreite) {
            int b = 1;
            while (b <= this.welt.areaLaenge) {
                boolean inv = false;
                int c = 0;
                while (c < this.welt.areaHoehe) {
                    if (this.welt.areaStapelInvalid[a][b][c]) {
                        inv = true;
                        this.welt.areaStapelInvalid[a][b][c] = false;
                    }
                    ++c;
                }
                if (inv) {
                    if (links > a) {
                        links = a;
                    }
                    if (oben > b) {
                        oben = b;
                    }
                    if (rechts < a) {
                        rechts = a;
                    }
                    if (unten < b) {
                        unten = b;
                    }
                }
                ++b;
            }
            ++a;
        }
        if (links != Integer.MAX_VALUE && links != Integer.MIN_VALUE) {
            links = Math.min(Math.max(1, links), this.welt.areaBreite);
            oben = Math.min(Math.max(1, oben), this.welt.areaLaenge);
            rechts = Math.min(Math.max(1, rechts), this.welt.areaBreite);
            unten = Math.min(Math.max(0, unten), this.welt.areaLaenge);
            this.zeichenWeltRechteck(links, oben, rechts, unten);
            this.revalidate();
            this.repaint();
        }
    }

    protected void zeichneWeltGanz() {
        this.loescheZeichenflaeche();
        this.zeichenWeltRechteck(1, 1, this.welt.areaBreite, this.welt.areaLaenge);
        int a = 1;
        while (a <= this.welt.areaBreite) {
            int b = 1;
            while (b <= this.welt.areaLaenge) {
                int c = 0;
                while (c < this.welt.areaHoehe) {
                    this.welt.areaStapelInvalid[a][b][c] = false;
                    ++c;
                }
                ++b;
            }
            ++a;
        }
        this.revalidate();
        this.repaint();
    }

    protected void resetWeltAnzeige() {
        this.loescheZeichenflaeche();
        this.paintImmediately(0, 0, this.getMinBreite(), this.getMinHoehe());
        this.zeichenFlaeche.flush();
        this.gDC = null;
        this.zeichenFlaecheVorbereiten();
        this.setBackground(Color.WHITE);
        this.setPreferredSize(new Dimension(this.getMinBreite(), this.getMinHoehe()));
        this.revalidate();
        this.repaint();
    }

    private void loescheZeichenflaeche() {
        Color aktuell = this.gDC.getColor();
        this.gDC.setColor(this.hintergrundFarbe);
        this.gDC.fillRect(0, 0, this.zeichenFlaeche.getWidth(), this.zeichenFlaeche.getHeight());
        this.gDC.setColor(aktuell);
    }

    private void zeichenFlaecheVorbereiten() {
        Point pp2 = new Point(0, 0);
        Dimension ergeb = new Dimension(0, 0);
        this.weltOrigin2D.x = 20;
        this.weltOrigin2D.y = 20;
        Point pp1 = this.p2(0, 0);
        pp2 = this.p2(this.welt.areaBreite, this.welt.areaLaenge);
        ergeb.width = Math.abs(pp1.x - pp2.x) + 40;
        ergeb.height = Math.abs(pp1.y - pp2.y) + 20 + 10;
        this.zeichenFlaeche = this.gfxConf.createCompatibleImage(ergeb.width, ergeb.height);
        this.gDC = this.zeichenFlaeche.createGraphics();
        this.loescheZeichenflaeche();
    }

    private void zeichenWeltRechteck(int links, int oben, int rechts, int unten) {
        Point pp2 = new Point(0, 0);
        int[] polyx = new int[3];
        int[] polyy = new int[3];
        String t = "";
        FontMetrics fm = null;
        Roboter robo = null;
        Point pp1 = this.p2(links - 1, oben - 1);
        pp2 = this.p2(rechts, unten);
        this.gDC.setColor(this.hintergrundFarbe);
        this.gDC.fillRect(pp1.x, pp1.y, pp2.x - pp1.x, pp2.y - pp1.y);
        this.gDC.setColor(Color.BLUE);
        int a = links;
        while (a <= rechts + 1) {
            pp1 = this.p2(a - 1, oben - 1);
            pp2 = this.p2(a - 1, unten);
            this.gDC.drawLine(pp1.x, pp1.y, pp2.x, pp2.y);
            ++a;
        }
        int b = oben;
        while (b <= unten + 1) {
            pp1 = this.p2(links - 1, b - 1);
            pp2 = this.p2(rechts, b - 1);
            this.gDC.drawLine(pp1.x, pp1.y, pp2.x, pp2.y);
            ++b;
        }
        a = links;
        while (a <= rechts) {
            int b2 = oben;
            while (b2 <= unten) {
                int rpos;
                int th;
                int tw;
                pp1 = this.p2(a - 1, b2 - 1);
                pp2.x = pp1.x + 30;
                pp2.y = pp1.y + 30;
                byte part = this.welt.getPart(a, b2, 0);
                if (part == this.welt.st_Ziegel || part >= this.welt.st_Ziegel_rot && part <= this.welt.st_Ziegel_gruen) {
                    byte parto = this.welt.getPart(a, b2, this.welt.areaStapelHoehe[a][b2] - 1);
                    int ziegelNr = parto == this.welt.st_Ziegel ? this.welt.st_Ziegel_rot : (int)((byte)(parto - this.welt.st_Ziegel_rot));
                    this.gDC.setColor(new Color(this.fuellFarbe[ziegelNr]));
                    this.gDC.fillRect(pp1.x + 1, pp1.y + 1, 28, 28);
                    this.gDC.setColor(new Color(this.randFarbe[ziegelNr]));
                    this.gDC.drawRect(pp1.x + 1, pp1.y + 1, 28, 28);
                    t = Integer.toString(this.welt.brickCount(a, b2));
                    this.gDC.setFont(new Font("Arial", 0, 15));
                    fm = this.gDC.getFontMetrics();
                    tw = (30 - fm.stringWidth(t)) / 2;
                    th = (30 + fm.getAscent()) / 2;
                    this.gDC.setColor(Color.WHITE);
                    this.gDC.drawString(t, (float)(pp1.x + tw), (float)(pp1.y + th));
                }
                if (part == this.welt.st_Quader) {
                    this.gDC.setColor(new Color(0x404040));
                    this.gDC.fillRect(pp1.x + 1, pp1.y + 1, 28, 28);
                    this.gDC.setColor(new Color(0x808080));
                    this.gDC.drawRect(pp1.x + 1, pp1.y + 1, 28, 28);
                }
                if (this.welt.isMarker(a, b2)) {
                    byte mark = this.welt.getMarker(a, b2);
                    int markeNr = mark == this.welt.st_Marke ? this.welt.st_Marke_gelb : (int)((byte)(mark - this.welt.st_Marke_rot));
                    this.gDC.setColor(new Color(this.randFarbe[markeNr]));
                    this.gDC.fillRect(pp1.x + 1, pp1.y + 1, 28, 28);
                    this.gDC.setColor(Color.BLACK);
                    this.gDC.drawRect(pp1.x + 1, pp1.y + 1, 28, 28);
                }
                if ((rpos = this.welt.getRobotIndex(a, b2)) >= 0) {
                    robo = (Roboter)this.welt.alleRoboter.get(rpos);
                    switch (robo.BlickrichtungGeben()) {
                        case 'S': {
                            polyx[0] = pp1.x + 1;
                            polyy[0] = pp1.y + 1;
                            polyx[1] = pp2.x - 1;
                            polyy[1] = pp1.y + 1;
                            polyx[2] = pp1.x + 15;
                            polyy[2] = pp2.y - 1;
                            break;
                        }
                        case 'O': {
                            polyx[0] = pp1.x + 1;
                            polyy[0] = pp2.y - 1;
                            polyx[1] = pp1.x + 1;
                            polyy[1] = pp1.y + 1;
                            polyx[2] = pp2.x - 1;
                            polyy[2] = pp1.y + 15;
                            break;
                        }
                        case 'N': {
                            polyx[0] = pp2.x - 1;
                            polyy[0] = pp2.y - 1;
                            polyx[1] = pp1.x + 1;
                            polyy[1] = pp2.y - 1;
                            polyx[2] = pp1.x + 15;
                            polyy[2] = pp1.y + 1;
                            break;
                        }
                        case 'W': {
                            polyx[0] = pp2.x - 1;
                            polyy[0] = pp1.y + 1;
                            polyx[1] = pp2.x - 1;
                            polyy[1] = pp2.y - 1;
                            polyx[2] = pp1.x + 1;
                            polyy[2] = pp1.y + 15;
                        }
                    }
                    this.gDC.setColor(Color.BLACK);
                    this.gDC.fill(new Polygon(polyx, polyy, 3));
                    if (this.welt.alleRoboter.size() > 1) {
                        t = Integer.toString(robo.KennungGeben());
                        this.gDC.setFont(new Font("Arial", 0, 15));
                        fm = this.gDC.getFontMetrics();
                        tw = (30 - fm.stringWidth(t)) / 2;
                        th = (30 + fm.getAscent()) / 2;
                        this.gDC.setColor(Color.WHITE);
                        this.gDC.drawString(t, (float)(pp1.x + tw), (float)(pp1.y + th));
                    }
                }
                ++b2;
            }
            ++a;
        }
    }

    private Point p2(int a, int b) {
        Point ergeb = new Point();
        a = Math.abs(a);
        b = Math.abs(b);
        ergeb.x = Math.round(this.weltOrigin2D.x + 30 * a);
        ergeb.y = Math.round(this.weltOrigin2D.y + 30 * b);
        return ergeb;
    }

    protected Point p2ToWelt(int x, int y) {
        Point ergeb = new Point();
        ergeb.x = (int)Math.floor((float)(x - this.weltOrigin2D.x) / 30.0f) + 1;
        ergeb.y = (int)Math.floor((float)(y - this.weltOrigin2D.y) / 30.0f) + 1;
        return ergeb;
    }
}

