
import javakarol.Roboter;
import javakarol.Welt;

/**
 * Karol steht in der Ecke (1,1) mit Blickrichtung.
 * Er soll eine Welt mit 3 Spalten mit Markierungen
 * in einem Schachbrettmuster auslegen.
 * 
 * Fr das Markieren einer Reihe wird eine Methode
 * MarkiereZeile() definiert.
 * 
 * Es wird die Karolwelt 09Schachbrett.kdw verwendet.
 * 
 * @author U.Freiberger
 */
public class Beispiel_09Schachbrett {

	Welt meineWelt;
	Roboter karol;
	
	Beispiel_09Schachbrett()
	{
		meineWelt = new Welt("Karolwelten/09Schachbrett.kdw");
		karol = new Roboter(meineWelt);
		
		for (int i=0; i<3;i++)
		{
			MarkiereZeile();
			karol.LinksDrehen();
			karol.Schritt();
			karol.LinksDrehen();
			MarkiereZeile();
			karol.RechtsDrehen();
			if (i<2)
				karol.Schritt();
			karol.RechtsDrehen();
		}
		karol.MeldungAusgeben("Bin mit dem Schachbrett zeichnen fertig.");
	}
	
	// Karol luft bis zur Wand und markiert jede zweite Kachel
	// des Boden
	public void MarkiereZeile()
	{
		while (!karol.IstWand())
		{
			karol.MarkeSetzen();
			karol.Schritt();
			if (!karol.IstWand())
				karol.Schritt();
		}
	}
	
	
	public static void main(String[] args) {
		new Beispiel_09Schachbrett();
	}

}
