
import javakarol.Roboter;
import javakarol.Welt;
import java.util.Random;

/**
 * Ein Beispielprogramm fr den Einsatz von
 * zwei Roboter.
 * 
 * KarolPolizist patrolliert entlang einer
 * Grenze aus Ziegelsteinen. KarolRuber luft
 * zufllig, frech hin und her, manchmal auch 
 * ber die Grenze. Bis er erwischt wird.
 * 
 * Es werden zwei Unterklassen der Klasse Roboter
 * erzeugt: Polizist und Raeuber.
 * 
 * Es wird die Karolwelt Grenze.jkw verwendet.
 * Diese enthlt die Ausgangsposition der beiden
 * Roboter.
 * 
 * @author U.Freiberger
 */

public class Beispiel_Grenze {

	Welt unsereWelt;
	Polizist karolPolizist;
	Raeuber karolRaeuber;
	
	Beispiel_Grenze()
	{
		unsereWelt = new Welt("Karolwelten/Grenze.jkw");
		karolPolizist = new Polizist(unsereWelt);
		karolRaeuber = new Raeuber(unsereWelt);
		
		while (!karolPolizist.IstRoboter())
		{
			karolPolizist.KontrollSchritt();
			karolRaeuber.ZufallsSchritt();
		}
		karolPolizist.MeldungAusgeben("Ich habe ihn erwischt.");
	}
	
	class Polizist extends Roboter
	{		
		Polizist(Welt inWelt)
		{
			super(inWelt);
		}
		
		void KontrollSchritt()
		{
			if (IstWand())
			{
				LinksDrehen();
				LinksDrehen();
			}
			if (!IstRoboter())
				Schritt();
		}

	}
	
	class Raeuber extends Roboter
	{
		Random zufall;
		
		public Raeuber(Welt inWelt)
		{
			super(inWelt);
			zufall = new Random();
		}
		
		void ZufallsSchritt()
		{
			int zufallsZahl = zufall.nextInt(3);
			if (zufallsZahl == 0)
				LinksDrehen();
			if (IstWand())
			{
				LinksDrehen();
				LinksDrehen();
			}
			if (!IstRoboter())
				Schritt();			
		}
	}
	
	
	
	public static void main(String[] args) {
		new Beispiel_Grenze();

	}

}
