
import javakarol.Roboter;
import javakarol.Welt;

/**
 * Karol luft auf einem geschlossenen Mauerzug
 * aus Ziegeln entlang, bis er die Marke erreicht.
 * Der Mauerzug muss passend aufgebaut sein, d.h.
 * an jeder Ecke gibt es einen eindeutigen 
 * Weiterweg, der ungleich der Ankunft ist.
 * 
 * Es wird die Karolwelt Laufen.kdw verwendet.
 * 
 * @author U.Freiberger
 *
 */

public class Beispiel_Laufen {

	Welt meineWelt;
	Roboter karol;
	
	
	Beispiel_Laufen()
	{
		meineWelt = new Welt("Karolwelten/Laufen.kdw");
		karol = new Roboter(meineWelt);
		
		// wiederhole bis karol auf der Marke steht
		while (!karol.IstMarke())
		{
			// ist vor Karol ein Ziegel, dann Schritt
			// sonst solange drehen bis vorne ein Ziegel ist
			if (karol.IstZiegel())
			{
				karol.Schritt();
			}
			else
			{
				karol.LinksDrehen();
				if (!karol.IstZiegel())
				{
					karol.LinksDrehen();
					karol.LinksDrehen();
				}
				karol.Schritt();
			}
		}		
		karol.MeldungAusgeben("Bin mit dem Laufen fertig.");
	}
	
	
	
	public static void main(String[] args)
	{
		new Beispiel_Laufen();
	}
	
}


