
import javakarol.Roboter;
import javakarol.Welt;

/**
 * Karol ist in einem Zimmer mit nur einem Ausgang.
 * Egal wo Karol steht er muss durch die Tre finden 
 * und auf dem Teppich vor dem Zimmer stehen bleiben.
 * 
 * Hierzu wird eine Unterklasse RobotPlus der Oberklasse
 * Roboter definiert. Ein Objekt der Klasse RobotPlus erbt 
 * alle Fhigkeiten und besitzt noch einige, fr diese
 * Aufgabenstellung frderliche zustzliche Methoden.
 * 
 * Es wird die Karolwelt Zimmer.kdw verwendet.
 * 
 * @author U.Freiberger
 */

public class Beispiel_Zimmer {

	Welt meineWelt;
	RobotPlus karol;

	Beispiel_Zimmer()
	{
		meineWelt = new Welt("Karolwelten/Zimmer.kdw");
		karol = new RobotPlus(meineWelt);
		
		karol.BisZurZiegelwand();
		karol.LinksDrehen();
		karol.AnDerZiegelwandEntlang();
		karol.RechtsDrehen();
		while (!karol.IstMarke())
			karol.Schritt();

		karol.MeldungAusgeben("Habe den Teppich gefunden.");
	}
	
	
	/**
	 * Hierzu ist eine verbesserte Roboterklasse RobotPlus
	 * erforderlich, die noch einige Fhigkeiten mehr besitzt.
	 */
	class RobotPlus extends Roboter
	{
		public RobotPlus(Welt inWelt)
		{
			super(inWelt);
		}
		
		/*
		 * Luft bis zur nchsten Ziegelwand
		 */
		void BisZurZiegelwand()
		{
			while (!IstZiegel())
			{
				Schritt();
			}
		}
		

		/*
		 * Luft an der Ziegelwand entlang
		 */
		void AnDerZiegelwandEntlang()
		{
			while (IstZiegelRechts())
			{
				if (IstZiegel())
					LinksDrehen();
				Schritt();
			}
		}
	}
	
	
	
	public static void main(String[] args) {
		new Beispiel_Zimmer();
	}

}
