
/**
 * Ein Beispielprogramm fr den Einsatz von zwei Roboter.
 * 
 * KarolPolizist patrolliert entlang einer Grenze aus
 * Ziegelsteinen. KarolRuber luft zufllig, frech hin 
 * und her, manchmal auch ber die Grenze. Bis er erwischt wird.
 * 
 * Es werden zwei Unterklassen der Klasse Roboter erzeugt: 
 * Polizist und Raeuber.
 * 
 * Es wird die Karolwelt Grenze.jkw verwendet.
 * Diese enthlt die Ausgangsposition der beiden Roboter.
 * 
 * @author U.Freiberger
 * @version 1.0 4.1.2008
 */
 
public class ARBEIT
{
    WELT unsereWelt;
    POLIZIST karolPolizist;
    RAEUBER karolRaeuber;

    /**
     * Konstruktor der Klasse ARBEIT
     * 
     * Erzeugt die fr die Methode Ausfuehren() erforderlichen 
     * Objekte der Klassen WELT und ROBOTER
     */
    public ARBEIT()
    {
        unsereWelt = new WELT("Grenze.jkw");
        karolPolizist = new POLIZIST(unsereWelt);        
        karolRaeuber = new RAEUBER(unsereWelt);        
    }

    
    /**
     * Methode Ausfuehren()
     * 
     * fhrt durch Aufruf von Robotermethoden die gestellte Aufgabe aus. 
     * Im Objektinspektor bei einem Objekt der Klasse ARBEIT aufrufen.
     */
    public void Ausfuehren()
    {
        while (!karolPolizist.IstRoboter())
        {
            karolPolizist.KontrollSchritt();
            karolRaeuber.ZufallsSchritt();
        }
        karolPolizist.MeldungAusgeben("Ich habe ihn erwischt.");
    }
 
    
    /**
     * Methode Zuruecksetzen()
     * 
     * setzt die Welt und den Roboter wieder in den Ausgangszustand zurck
     */
    public void ZurueckSetzen()
    {
        unsereWelt.ZurueckSetzen();
    }
    
}
