
/**
 * Eine Unterklasse der Klasse ROBOTER.
 * 
 * Beherrscht eine Reihe von Methoden, die das Invertieren vereinfachen
 * Kann Welten invertieren auf der einzelnen Ziegel (keine Stapel)
 * verstreut sind.
 * 
 * Zur Vereinfachung wird vorausgesetzt, dass der Roboter zu Beginn
 * auf der Position 1 steht mit Blickrichtung Sden.
 * 
 * 
 * @author U.Freiberger
 * @version 1.0 4.1.2008
 */
public class INVERTIERROBOTER extends ROBOTER
{
    /**
     * Konstruktor fr Objekte der Klasse INVERTIERROBOTER
     */
    public INVERTIERROBOTER(WELT inWelt)
    {
        super(1,1,'S',inWelt);
    }

    
    /**
     * Invertiert einen Ziegel vor dem Roboter
     */
    public void EinenZiegelInvertieren()
    {
        if (IstZiegel())
            Aufheben();
        else
            Hinlegen();
    }


    /**
     * Invertiert eine Reihe von Ziegel bis zur Wand
     */
    public void EineReiheInvertieren()
    {
        while (!IstWand())
        {
            EinenZiegelInvertieren();
            Schritt();
        }
    }


    /**
     * Dreht an der Wand gegen den Uhrzeigersinn um
     * und invertiert den Ziegel am Rand
     */
    public void GegenUhrzeigersinn()
    {
        LinksDrehen();
        if (!IstWand())
        {
            EinenZiegelInvertieren();
            Schritt();
            LinksDrehen();
        }
    }

    /**
     * Dreht an der Wand im Uhrzeigersinn um
     * und invertiert den Ziegel am Rand
     */
    public void ImUhrzeigersinn()
    {
        RechtsDrehen();
        if (!IstWand())
        {
            EinenZiegelInvertieren();
            Schritt();
            RechtsDrehen();
        }
    }


    /**
     * Die Startposition invertieren
     */
    public void StartInvertieren()
    {
        Schritt();
        LinksDrehen();
        LinksDrehen();
        EinenZiegelInvertieren();
        Schritt();
        LinksDrehen();
        LinksDrehen();
    }

    
    /**
     * Die ganze Welt invertieren
     */
    public void WeltInvertieren()
    {
        StartInvertieren();
        while (!IstWand())
        {
            EineReiheInvertieren();
            if (IstBlickSueden())
                GegenUhrzeigersinn();
            else
                ImUhrzeigersinn();
        }
    }


    
    

}

