
/**
 * Karol durchwandert ein "zeilenorientiertes"
 * Labyrinth bis zur Markierung. 
 * 
 * Eine Unterklasse SPEZIALROBOTER von ROBOTER besitzt hierzu einige
 * brauchbare logische Abfragefunktionen.
 * 
 * Es wird die Karolwelt Labyrinth_einfach.kdw verwendet.
 * 
 * @author U.Freiberger
 * @version 1.0 4.1.2008
 */
 
public class ARBEIT
{

    WELT meineWelt;
    SPEZIALROBOTER karol;

    /**
     * Konstruktor der Klasse ARBEIT
     * 
     * Erzeugt die fr die Methode Ausfuehren() erforderlichen 
     * Objekte der Klassen WELT und INVERTIERROBOTER
     */
    public ARBEIT()
    {
        meineWelt = new WELT("Labyrinth_einfach.kdw");
        karol = new SPEZIALROBOTER(meineWelt);        
    }

    
    /**
     * Methode Ausfuehren()
     * 
     * fhrt durch Aufruf von Robotermethoden die gestellte Aufgabe aus. 
     * Im Objektinspektor bei einem Objekt der Klasse ARBEIT aufrufen.
     */
    public void Ausfuehren()
    {
        // Karol muss nach rechts schauen
        while (!karol.IstBlickOsten())
            karol.LinksDrehen();
        
        // jetzt geht es los bis zur Marke
        while (!karol.IstMarke())
        {
            // eine ffnung links suchen
            while (karol.IstLinksZiegelundVorneFrei())
                karol.Schritt();
               
            if (karol.IstLinksZiegel())
            {
                // keine ffnung links sondern Reihenende
                // Umdrehen
                karol.LinksDrehen();
                karol.LinksDrehen();
                
                // eine ffnung rechts suchen
                while (karol.IstRechtsZiegelundVorneFrei())
                    karol.Schritt();
                    
                if (karol.IstRechtsZiegel())
                {
                    // keine ffnung rechts sondern Reihenende
                    // dann Fehler im Labyrint
                    karol.TonErzeugen();
                    karol.MeldungAusgeben("Labyrinth ist falsch");
                }
                else // !IstRechtsZiegel
                {
                    // ffnung rechts
                    karol.RechtsDrehen();
                    karol.Schritt();
                    karol.Schritt();
                    karol.RechtsDrehen();
                }

            }
            else  // !IstLinksZiegel
            {
                // ffnung links
                karol.LinksDrehen();
                karol.Schritt();
                karol.Schritt();
                karol.RechtsDrehen();
            }
            
        } // wdh. !IstMarker
        
        karol.LinksDrehen();
        
        karol.MeldungAusgeben("Habe aus dem Labyrinth rausgefunden.");
    }
 
    
    /**
     * Methode Zuruecksetzen()
     * 
     * setzt die Welt und den Roboter wieder in den Ausgangszustand zurck
     */
    public void ZurueckSetzen()
    {
        meineWelt.ZurueckSetzen();
    }
    
}
