
/**
 * Karol luft auf einem geschlossenen Mauerzug aus Ziegeln entlang, 
 * bis er die Marke erreicht. Der Mauerzug muss passend aufgebaut sein, 
 * d.h. an jeder Ecke gibt es einen eindeutigen Weiterweg, der ungleich 
 * der Ankunft ist.
 * 
 * Es wird die Karolwelt Laufen.kdw verwendet.
 * 
 * @author U.Freiberger
 * @version 1.0 4.1.2008
 */
 
public class ARBEIT
{

	WELT meineWelt;
	ROBOTER karol;

    /**
     * Konstruktor der Klasse ARBEIT
     * 
     * Erzeugt die fr die Methode Ausfuehren() erforderlichen 
     * Objekte der Klassen WELT und ROBOTER
     */
	public ARBEIT()
    {
   		meineWelt = new WELT("Laufen.kdw");
		karol = new ROBOTER(meineWelt);        
    }

    /**
     * Methode Ausfuehren()
     * 
     * fhrt durch Aufruf von Robotermethoden die gestellte Aufgabe aus. 
     * Im Objektinspektor bei einem Objekt der Klasse ARBEIT aufrufen.
     */
    public void Ausfuehren()
    {
		// wiederhole bis karol auf der Marke steht
		while (!karol.IstMarke())
		{
			// ist vor Karol ein Ziegel, dann Schritt
			// sonst solange drehen bis vorne ein Ziegel ist
			if (karol.IstZiegel())
			{
				karol.Schritt();
			}
			else
			{
				karol.LinksDrehen();
				if (!karol.IstZiegel())
				{
					karol.LinksDrehen();
					karol.LinksDrehen();
				}
				karol.Schritt();
			}
		}		
		karol.MeldungAusgeben("Bin mit dem Laufen fertig.");
    }
    
    public void ZurueckSetzen()
    {
        meineWelt.ZurueckSetzen();
    }
    
}
