import java.util.Random;

/**
 * Eine Unterklasse der Klasse ROBOTER.
 * 
 * KarolLufer ist ein Sportler, der geradeaus auf seiner Startbahn luft.
 * Die Welt vor ihm muss frei von Hindernissen sein.
 * 
 * Bei jedem Aufruf der Methode LaufSchritt() bewegt er sich vorwrts
 *      (maximal bis zur Wand)
 * Die Anzahl der Schritte schwankt zufllig zwischen 1 und maxSchritt
 * 
 * @author U.Freiberger
 * @version 1.0 24.6.2008
 */
public class LAEUFER extends ROBOTER
{
    Random zufall;
    int maxSchritt;

    
    /**
     * Konstruktor fr Objekte der Klasse LAEUFER
     * Erzeugen eines neuen Lufers mit vorgegebener Startbahn und Leistungsfhigkeit
     * 
     * Vorher muss ein Objekt der Klasse WELT angelegt werden, in der der Lufer luft. 
     * 
     * @param startbahn mit 1..WeltBreite
     * @param qualitaet = Leistungsfhigkeit von 1 bis 4 
     * @param Referenz auf die Welt in der der Lufer laufen soll 
     * 
     */
    public LAEUFER(int startbahn, int qualitaet, WELT inWelt)
    {
        super(startbahn,1,'S',inWelt);
        zufall = new Random();
        this.maxSchritt = Math.max(Math.min(qualitaet,4),1);
    }

    
    /**
     * Fhrt einen Laufschritt aus, in dem er zufallsgesteuert 
     * einen Schritt zwischen 1 und maximalem Schritt ausfhrt.
     * 
     * @return true bedeutet das Ziel ist erreicht
     */
    public boolean LaufSchritt()
    {
        int zufallsZahl = zufall.nextInt(maxSchritt)+1;
        while (zufallsZahl>0 && !IstWand())
        {
            Schritt();
            zufallsZahl = zufallsZahl - 1;
        }
        if (IstWand())
        {
            MeldungAusgeben("Habe das Ziel erreicht.");
            return true;
        }
        else
            return false;
    }
    
}
