/*
 * Decompiled with CFR 0.152.
 */
package javakarol;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javakarol.Roboter;
import javakarol.Welt;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class WeltAnzeige3D
extends JPanel {
    private Welt welt;
    private GraphicsConfiguration gfxConf;
    private BufferedImage zeichenFlaeche;
    private Point weltOrigin3D = new Point(0, 0);
    private Graphics2D gDC;
    protected BufferedImage quaderImg = null;
    protected BufferedImage[] ziegelImg = new BufferedImage[4];
    protected BufferedImage[] markeImg = new BufferedImage[5];
    private final int maxRobotImages = 9;
    protected BufferedImage[][] karolImg = new BufferedImage[4][9];
    private BufferedImage weltFlaeche = null;
    protected int maxImageHoehe = 10;
    private Color hintergrundFarbe = Color.WHITE;
    private final int randLinks = 40;
    private final int randOben = 40;
    private final int randUnten = 30;
    private final int weltOben = 20;
    private int zoomWert = 0;
    private double[] zoomFaktor = new double[]{0.6, 0.7, 0.8, 1.0, 1.5, 2.0, 2.5};

    public WeltAnzeige3D(Welt welt) {
        this.welt = welt;
        this.gfxConf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        this.zeichenFlaecheVorbereiten();
        this.weltFlaecheVorbereiten();
        this.imagesLaden();
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createLineBorder(Color.red));
        this.setOpaque(true);
        this.zoomWert = 0;
        this.setPreferredSize(new Dimension(this.getMinBreite(), this.getMinHoehe()));
    }

    public int getMinBreite() {
        if (this.zoomWert == 0) {
            return this.zeichenFlaeche.getWidth() + 10;
        }
        return (int)(this.zoomFaktor[this.zoomWert + 3] * (double)this.zeichenFlaeche.getWidth() + 10.0);
    }

    public int getMinHoehe() {
        if (this.zoomWert == 0) {
            return this.zeichenFlaeche.getHeight() + 10;
        }
        return (int)(this.zoomFaktor[this.zoomWert + 3] * (double)this.zeichenFlaeche.getHeight() + 10.0);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.zoomWert == 0) {
            g.drawImage(this.zeichenFlaeche, 0, 0, null);
        } else {
            Graphics2D g2 = (Graphics2D)g;
            g2.scale(this.zoomFaktor[this.zoomWert + 3], this.zoomFaktor[this.zoomWert + 3]);
            g2.drawImage((Image)this.zeichenFlaeche, 0, 0, null);
        }
    }

    public void paintToFile(File f, String fileTyp) {
        try {
            ImageIO.write((RenderedImage)this.zeichenFlaeche, fileTyp, f);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected BufferedImage getZeichenflaeche() {
        return this.zeichenFlaeche;
    }

    private void loescheZeichenflaeche() {
        Color aktuell = this.gDC.getColor();
        this.gDC.setColor(this.hintergrundFarbe);
        this.gDC.fillRect(0, 0, this.zeichenFlaeche.getWidth(), this.zeichenFlaeche.getHeight());
        this.gDC.setColor(aktuell);
    }

    protected void zeichneWelt() {
        int links = Integer.MAX_VALUE;
        int oben = Integer.MAX_VALUE;
        int rechts = Integer.MIN_VALUE;
        int unten = Integer.MIN_VALUE;
        Point p1 = new Point(0, 0);
        Point p2 = new Point(0, 0);
        int a = 1;
        while (a <= this.welt.areaBreite) {
            int b = 1;
            while (b <= this.welt.areaLaenge) {
                int c = 0;
                while (c < this.welt.areaHoehe) {
                    if (this.welt.areaStapelInvalid[a][b][c]) {
                        p1 = this.p3(a - 1, b, c);
                        p2 = this.p3(a, b - 1, c);
                        if (links > p1.x) {
                            links = p1.x;
                        }
                        if (oben > p2.y - this.maxImageHoehe) {
                            oben = p2.y - this.maxImageHoehe;
                        }
                        if (rechts < p2.x) {
                            rechts = p2.x;
                        }
                        if (unten < p1.y) {
                            unten = p1.y;
                        }
                        this.welt.areaStapelInvalid[a][b][c] = false;
                    }
                    ++c;
                }
                ++b;
            }
            ++a;
        }
        if (links != Integer.MAX_VALUE && links != Integer.MIN_VALUE) {
            links = Math.max(0, links - 10);
            oben = Math.max(0, oben - 10);
            rechts = Math.min(this.weltFlaeche.getWidth(), rechts + 10);
            unten = Math.min(this.weltFlaeche.getHeight(), unten + 10);
            this.zeichenWeltRechteck(links, oben, rechts, unten);
            this.revalidate();
            this.repaint();
        }
    }

    protected void zeichneWeltGanz() {
        this.loescheZeichenflaeche();
        this.zeichenWeltRechteck(0, 0, this.weltFlaeche.getWidth(), this.weltFlaeche.getHeight());
        int a = 1;
        while (a <= this.welt.areaBreite) {
            int b = 1;
            while (b <= this.welt.areaLaenge) {
                int c = 0;
                while (c < this.welt.areaHoehe) {
                    this.welt.areaStapelInvalid[a][b][c] = false;
                    ++c;
                }
                ++b;
            }
            ++a;
        }
        this.revalidate();
        this.repaint();
    }

    private void zeichenWeltRechteck(int x1, int y1, int x2, int y2) {
        Point p1 = new Point(0, 0);
        Rectangle clipRect = new Rectangle(x1, y1, x2 - x1, y2 - y1);
        this.gDC.setClip(x1 + 40, y1 + 40, x2 - x1, y2 - y1);
        this.gDC.drawImage(this.weltFlaeche, x1 + 40, y1 + 40, x2 + 40, y2 + 40, x1, y1, x2, y2, this);
        int a = 1;
        while (a <= this.welt.areaBreite) {
            int b = 1;
            while (b <= this.welt.areaLaenge) {
                int c = 0;
                while (c <= this.welt.areaStapelHoehe[a][b]) {
                    byte part = this.welt.getPart(a, b, c);
                    if (part == this.welt.st_Ziegel || part >= this.welt.st_Ziegel_rot && part <= this.welt.st_Ziegel_gruen) {
                        int ziegelNr = part == this.welt.st_Ziegel ? this.welt.st_Ziegel_rot : (int)((byte)(part - this.welt.st_Ziegel_rot));
                        p1 = this.p3(a - 1, b, c);
                        p1.y -= this.ziegelImg[ziegelNr].getHeight();
                        if (clipRect.intersects(new Rectangle(p1.x, p1.y, this.ziegelImg[ziegelNr].getWidth(), this.ziegelImg[ziegelNr].getHeight()))) {
                            this.gDC.drawImage((Image)this.ziegelImg[ziegelNr], p1.x + 40, p1.y + 40, this);
                        }
                    }
                    if (part == this.welt.st_Quader) {
                        p1 = this.p3(a - 1, b, 0.0f);
                        p1.y -= this.quaderImg.getHeight();
                        if (clipRect.intersects(new Rectangle(p1.x, p1.y, this.quaderImg.getWidth(), this.quaderImg.getHeight()))) {
                            this.gDC.drawImage((Image)this.quaderImg, p1.x + 40, p1.y + 40, this);
                        }
                    }
                    if (this.welt.isMarker(a, b) && this.welt.brickCount(a, b) == c) {
                        byte mark = this.welt.getMarker(a, b);
                        int markeNr = mark == this.welt.st_Marke ? this.welt.st_Marke_gelb : (int)((byte)(mark - this.welt.st_Marke_rot));
                        p1 = this.p3(a - 1, b, c);
                        p1.y -= this.markeImg[markeNr].getHeight();
                        if (clipRect.intersects(new Rectangle(p1.x, p1.y, this.markeImg[markeNr].getWidth(), this.markeImg[markeNr].getHeight()))) {
                            this.gDC.drawImage((Image)this.markeImg[markeNr], p1.x + 40, p1.y + 40, this);
                        }
                    }
                    int anzRoboter = this.welt.alleRoboter.size();
                    int i = 0;
                    while (i < anzRoboter) {
                        Roboter robo = (Roboter)this.welt.alleRoboter.get(i);
                        if (a == robo.PositionXGeben() && b == robo.PositionYGeben() && c == this.welt.areaStapelHoehe[a][b] && robo.SichtbarkeitGeben()) {
                            p1 = this.p3((float)a - 0.9f, (float)b - 0.3f, c);
                            int richtung = robo.getBlickrichtungNr();
                            int knr = Math.min(Math.max(robo.KennungGeben() - 1, 0), 8);
                            p1.x -= (this.karolImg[richtung][knr].getWidth() - 30) / 2;
                            p1.y -= this.karolImg[richtung][knr].getHeight();
                            if (clipRect.intersects(new Rectangle(p1.x, p1.y, this.karolImg[richtung][knr].getWidth(), this.karolImg[richtung][knr].getHeight()))) {
                                this.gDC.drawImage((Image)this.karolImg[richtung][knr], p1.x + 40, p1.y + 40, this);
                            }
                        }
                        ++i;
                    }
                    ++c;
                }
                ++b;
            }
            ++a;
        }
    }

    private void weltFlaecheVorbereiten() {
        Point p1 = new Point(0, 0);
        Point p2 = new Point(0, 0);
        float[] dash_array = new float[]{10.0f, 5.0f, 5.0f, 5.0f};
        BasicStroke gestrichelt = new BasicStroke(1.0f, 0, 2, 1.0f, dash_array, 0.0f);
        BasicStroke durchgehend = new BasicStroke();
        this.weltFlaeche = this.gfxConf.createCompatibleImage(this.zeichenFlaeche.getWidth() - 80 + 1, this.zeichenFlaeche.getHeight() - 40 - 30 + 1);
        Graphics2D g = this.weltFlaeche.createGraphics();
        g.setColor(this.hintergrundFarbe);
        g.fillRect(0, 0, this.weltFlaeche.getWidth(), this.weltFlaeche.getHeight());
        g.setColor(Color.BLUE);
        g.setStroke(durchgehend);
        int i = 0;
        while (i <= this.welt.areaLaenge) {
            p1 = this.p3(0.0f, i, 0.0f);
            p2 = this.p3(this.welt.areaBreite, i, 0.0f);
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
            ++i;
        }
        i = 0;
        while (i <= this.welt.areaBreite) {
            p1 = this.p3(i, 0.0f, 0.0f);
            p2 = this.p3(i, this.welt.areaLaenge, 0.0f);
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
            ++i;
        }
        g.setStroke(gestrichelt);
        i = 0;
        while (i <= this.welt.areaBreite) {
            p1 = this.p3(i, 0.0f, 0.0f);
            p2 = this.p3(i, 0.0f, this.welt.areaHoehe);
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
            ++i;
        }
        p1 = this.p3(this.welt.areaBreite, 0.0f, this.welt.areaHoehe);
        p2 = this.p3(0.0f, 0.0f, this.welt.areaHoehe);
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
        i = 0;
        while (i <= this.welt.areaLaenge) {
            p1 = this.p3(0.0f, i, 0.0f);
            p2 = this.p3(0.0f, i, this.welt.areaHoehe);
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
            ++i;
        }
        p1 = this.p3(0.0f, this.welt.areaLaenge, this.welt.areaHoehe);
        p2 = this.p3(0.0f, 0.0f, this.welt.areaHoehe);
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
        g.setStroke(durchgehend);
        p1 = this.p3(-2.0f, 0.0f, this.welt.areaHoehe);
        p2 = this.p3(-2.0f, 2.0f, this.welt.areaHoehe);
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
        g.drawLine(p1.x - 10, p1.y + 5, p1.x, p1.y);
        g.drawLine(p1.x - 5, p1.y + 10, p1.x, p1.y);
        g.setFont(new Font("Arial", 0, 14));
        g.drawString("N", p1.x + 4, p1.y);
    }

    protected BufferedImage imageLadenName(String name) {
        BufferedImage bi = null;
        URL u = ClassLoader.getSystemResource("imgs/" + name + ".gif");
        if (u == null) {
            u = WeltAnzeige3D.class.getResource("imgs/" + name + ".gif");
        }
        try {
            bi = ImageIO.read(u);
        }
        catch (IOException e) {
            System.out.println("Ein noetiges Image f\u00fcr Ziegel/Quader/Roboter kann nicht geladen werden.");
            throw new RuntimeException("Fehler beim Laden eines Images.");
        }
        if (bi.getHeight() > this.maxImageHoehe) {
            this.maxImageHoehe = bi.getHeight();
        }
        return bi;
    }

    protected void imagesLaden() {
        this.ziegelImg[0] = this.imageLadenName("Ziegel_rot");
        this.ziegelImg[1] = this.imageLadenName("Ziegel_gelb");
        this.ziegelImg[2] = this.imageLadenName("Ziegel_blau");
        this.ziegelImg[3] = this.imageLadenName("Ziegel_gruen");
        this.markeImg[0] = this.imageLadenName("Marke_rot");
        this.markeImg[1] = this.imageLadenName("Marke_gelb");
        this.markeImg[2] = this.imageLadenName("Marke_blau");
        this.markeImg[3] = this.imageLadenName("Marke_gruen");
        this.markeImg[4] = this.imageLadenName("Marke_schwarz");
        this.quaderImg = this.imageLadenName("Quader");
        int i = 1;
        while (i <= 9) {
            this.karolImg[0][i - 1] = this.imageLadenName("robotS" + i);
            this.karolImg[1][i - 1] = this.imageLadenName("robotW" + i);
            this.karolImg[2][i - 1] = this.imageLadenName("robotN" + i);
            this.karolImg[3][i - 1] = this.imageLadenName("robotO" + i);
            ++i;
        }
    }

    private Point p3(float x, float y, float z) {
        Point ergeb = new Point();
        ergeb.x = Math.round((float)this.weltOrigin3D.x + 30.0f * x - 15.0f * y);
        ergeb.y = Math.round((float)this.weltOrigin3D.y + 15.0f * y - 15.0f * z);
        return ergeb;
    }

    private void zeichenFlaecheVorbereiten() {
        Dimension ergeb = new Dimension(0, 0);
        Point[] punkte = new Point[8];
        int links = Integer.MAX_VALUE;
        int oben = Integer.MAX_VALUE;
        int rechts = Integer.MIN_VALUE;
        int unten = Integer.MIN_VALUE;
        punkte[0] = this.p3(0.0f, 0.0f, 0.0f);
        punkte[1] = this.p3(0.0f, 0.0f, this.welt.areaHoehe);
        punkte[2] = this.p3(0.0f, this.welt.areaLaenge, 0.0f);
        punkte[3] = this.p3(0.0f, this.welt.areaLaenge, this.welt.areaHoehe);
        punkte[4] = this.p3(this.welt.areaBreite, 0.0f, 0.0f);
        punkte[5] = this.p3(this.welt.areaBreite, 0.0f, this.welt.areaHoehe);
        punkte[6] = this.p3(this.welt.areaBreite, this.welt.areaLaenge, 0.0f);
        punkte[7] = this.p3(this.welt.areaBreite, this.welt.areaLaenge, this.welt.areaHoehe);
        int i = 0;
        while (i < 7) {
            if (punkte[i].x > rechts) {
                rechts = punkte[i].x;
            }
            if (punkte[i].y > unten) {
                unten = punkte[i].y;
            }
            if (punkte[i].x < links) {
                links = punkte[i].x;
            }
            if (punkte[i].y < oben) {
                oben = punkte[i].y;
            }
            ++i;
        }
        ergeb.width = Math.abs(rechts - links) + 80;
        ergeb.height = Math.abs(unten - oben) + 40 + 30 + 20;
        this.weltOrigin3D.x = Math.abs(punkte[0].x - links);
        this.weltOrigin3D.y = Math.abs(punkte[0].y - oben) + 20;
        this.zeichenFlaeche = this.gfxConf.createCompatibleImage(ergeb.width, ergeb.height);
        this.gDC = this.zeichenFlaeche.createGraphics();
        this.loescheZeichenflaeche();
    }

    protected void resetWeltAnzeige() {
        this.loescheZeichenflaeche();
        this.paintImmediately(0, 0, this.getMinBreite(), this.getMinHoehe());
        this.zoomWert = 0;
        this.zeichenFlaeche.flush();
        this.weltFlaeche.flush();
        this.gDC = null;
        this.zeichenFlaecheVorbereiten();
        this.weltFlaecheVorbereiten();
        this.setBackground(Color.WHITE);
        this.setPreferredSize(new Dimension(this.getMinBreite(), this.getMinHoehe()));
        this.revalidate();
        this.repaint();
    }

    public int getZoomWert() {
        return this.zoomWert;
    }

    private void zoomSetzen(int neuerWert) {
        if (this.zoomWert != neuerWert) {
            this.loescheZeichenflaeche();
            this.paintImmediately(0, 0, this.getMinBreite(), this.getMinHoehe());
            this.zoomWert = neuerWert;
            this.setBackground(Color.WHITE);
            this.setPreferredSize(new Dimension(this.getMinBreite(), this.getMinHoehe()));
            this.revalidate();
            this.repaint();
        }
    }

    public boolean zoomen(boolean hinein) {
        int neuerWert = this.zoomWert;
        boolean ergeb = false;
        if (hinein && this.zoomWert < 3) {
            ++neuerWert;
        }
        if (!hinein && this.zoomWert > -3) {
            --neuerWert;
        }
        if (neuerWert != this.zoomWert) {
            this.zoomSetzen(neuerWert);
            ergeb = true;
        }
        return ergeb;
    }

    public void zoomZuruecksetzen() {
        if (this.zoomWert != 0) {
            this.zoomSetzen(0);
        }
    }
}

