/*
 * Decompiled with CFR 0.152.
 */
package karoleditor;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import karoleditor.KEdtRegexLexer;
import karoleditor.KEdtStyleContext;
import karoleditor.KEdtToken;

public class KEdtDocument
extends DefaultStyledDocument {
    private Pattern searchPattern = null;
    private KEdtRegexLexer lexer = new KEdtRegexLexer();
    private List<KEdtToken> tokens;
    private boolean mitParsen = true;
    private boolean mitSchreibweise = true;
    private boolean istGeaendert = false;

    public KEdtDocument() {
        super(new KEdtStyleContext());
    }

    @Override
    protected void fireInsertUpdate(DocumentEvent e) {
        super.fireInsertUpdate(e);
        this.istGeaendert = true;
        if (this.mitParsen) {
            this.parse();
            this.highLight();
        }
    }

    @Override
    protected void fireRemoveUpdate(DocumentEvent e) {
        super.fireRemoveUpdate(e);
        this.istGeaendert = true;
        if (this.mitParsen) {
            this.parse();
            this.highLight();
        }
    }

    public void setMitParsen(boolean status) {
        this.mitParsen = status;
    }

    public void setMitSchreibweise(boolean status) {
        this.mitSchreibweise = status;
    }

    public boolean getMitSchreibweise() {
        return this.mitSchreibweise;
    }

    public void resetModified() {
        this.istGeaendert = false;
    }

    public boolean getModified() {
        return this.istGeaendert;
    }

    public void setStyleColor(KEdtToken.TokenType typ, int hexColor) {
        Style s = this.getStyle(KEdtStyleContext.styleName[typ.ordinal()]);
        StyleConstants.setForeground(s, new Color(hexColor));
    }

    public int getStyleColor(KEdtToken.TokenType typ) {
        Style s = this.getStyle(KEdtStyleContext.styleName[typ.ordinal()]);
        return StyleConstants.getForeground(s).getRGB();
    }

    public void setFontsizeNormal(int pt) {
        Style s = this.getStyle("normal");
        StyleConstants.setFontSize(s, pt);
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        StyleConstants.setFontSize(def, pt);
    }

    public int getFontsizeNormal() {
        Style s = this.getStyle("normal");
        return StyleConstants.getFontSize(s);
    }

    private void parse() {
        int len = this.getLength();
        if (this.lexer == null) {
            this.tokens = null;
            return;
        }
        ArrayList<KEdtToken> toks = new ArrayList<KEdtToken>(len / 5);
        try {
            Segment seg = new Segment();
            this.getText(0, len, seg);
            this.lexer.parse(seg, 0, toks);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.tokens = toks;
    }

    private void highLight() {
        int z = 0;
        int maxToken = 700;
        int klammer = 0;
        if (this.lexer == null || this.tokens == null || this.tokens.isEmpty()) {
            return;
        }
        this.setCharacterAttributes(0, this.getLength(), this.getStyle("leer"), true);
        ListIterator<KEdtToken> ti = this.tokens.listIterator();
        while (ti.hasNext() && z < maxToken) {
            KEdtToken t = ti.next();
            klammer = t.getTyp() == KEdtToken.TokenType.PNUMBER || t.getTyp() == KEdtToken.TokenType.PCOLOR ? 1 : 0;
            this.setCharacterAttributes(t.getStart() + klammer, t.getLength() - 2 * klammer, this.getStyle(t.getStyle()), false);
            ++z;
        }
    }

    public void replaceToken(KEdtToken token, String replacement) {
        try {
            this.replace(token.start, token.length, replacement, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void showAllTokens() {
        if (this.lexer == null || this.tokens == null || this.tokens.isEmpty()) {
            return;
        }
        ListIterator<KEdtToken> ti = this.tokens.listIterator();
        while (ti.hasNext()) {
            KEdtToken t = ti.next();
            JOptionPane.showMessageDialog(null, t.toString());
        }
    }

    public KEdtToken getTokenAt(int pos) {
        if (this.tokens == null || this.tokens.isEmpty() || pos > this.getLength()) {
            return null;
        }
        KEdtToken tok = null;
        int ndx = Collections.binarySearch(this.tokens, new KEdtToken(KEdtToken.TokenType.DEFAULT, pos, 1));
        if (ndx < 0) {
            ndx = -ndx - 1 - 1 < 0 ? 0 : -ndx - 1 - 1;
            KEdtToken t = this.tokens.get(ndx);
            if (t.start <= pos && pos <= t.getEnd()) {
                tok = t;
            }
        } else {
            tok = this.tokens.get(ndx);
        }
        return tok;
    }

    public String getString(KEdtToken token) {
        String result = "";
        if (token != null) {
            try {
                result = this.getText(token.start, token.length);
            }
            catch (BadLocationException ex) {
                return result;
            }
        }
        return result;
    }

    public String getStringLower(KEdtToken token) {
        return this.getString(token).toLowerCase();
    }

    public KEdtToken getNextToken(KEdtToken tok) {
        int n = this.tokens.indexOf(tok);
        if (n >= 0 && n < this.tokens.size() - 1) {
            return this.tokens.get(n + 1);
        }
        return null;
    }

    public KEdtToken getPrevToken(KEdtToken tok) {
        int n = this.tokens.indexOf(tok);
        if (n > 0 && !this.tokens.isEmpty()) {
            return this.tokens.get(n - 1);
        }
        return null;
    }

    public List<KEdtToken> getTokenList() {
        return this.tokens;
    }

    public void getNewTokenListMitLine(List<KEdtToken> tok) {
        tok.clear();
        if (this.tokens == null || this.tokens.isEmpty()) {
            return;
        }
        ListIterator<KEdtToken> ti = this.tokens.listIterator();
        while (ti.hasNext()) {
            KEdtToken t = ti.next();
            tok.add(new KEdtToken(t.type, t.start, t.length, this.getLineNumberToken(t)));
        }
    }

    public Pattern getPattern() {
        return this.searchPattern;
    }

    private Pattern createPattern(String suchStr, boolean regExp, boolean grossKlein, boolean nurGanzeWoerter) {
        int flag = 0;
        if (suchStr != null && suchStr.length() > 0) {
            if (regExp) {
                flag |= 0x10;
            }
            if (!grossKlein) {
                flag |= 2;
            }
            if (nurGanzeWoerter) {
                suchStr = "[\\b\\s\\.,;!?]" + suchStr + "[\\b\\s\\.,;!?]";
            }
            return Pattern.compile(suchStr, flag);
        }
        return null;
    }

    private Matcher createMatcher(Pattern pattern, int start, int laenge) {
        Matcher matcher = null;
        if (pattern == null) {
            return null;
        }
        if (this.getLength() == 0) {
            return null;
        }
        if (start >= this.getLength()) {
            return null;
        }
        if (start < 0) {
            start = 0;
        }
        if (start + laenge > this.getLength()) {
            laenge = this.getLength() - start;
        }
        try {
            Segment seg = new Segment();
            this.getText(start, laenge, seg);
            matcher = pattern.matcher(seg);
        }
        catch (BadLocationException ex) {
            matcher = null;
        }
        return matcher;
    }

    private void doReplace(String suchStr, String ersetzStr, int start, int laenge, boolean grossKlein, boolean nurGanzeWoerter) {
        if (ersetzStr == null) {
            ersetzStr = "";
        }
        this.searchPattern = this.createPattern(suchStr, true, grossKlein, nurGanzeWoerter);
        if (this.searchPattern == null) {
            return;
        }
        Matcher matcher = this.createMatcher(this.searchPattern, start, laenge);
        String newText = matcher.replaceAll(ersetzStr);
        try {
            this.replace(start, laenge, newText, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void doReplaceAll(String suchStr, String ersetzStr, boolean grossKlein, boolean nurGanzeWoerter) {
        this.doReplace(suchStr, ersetzStr, 0, this.getLength(), grossKlein, nurGanzeWoerter);
    }

    public void doReplaceFromCursor(String suchStr, String ersetzStr, boolean grossKlein, boolean nurGanzeWoerter, JEditorPane editorPane) {
        int start = editorPane.getCaretPosition();
        this.doReplace(suchStr, ersetzStr, start, this.getLength() - start, grossKlein, nurGanzeWoerter);
    }

    public void doReplaceSelected(String suchStr, String ersetzStr, boolean grossKlein, boolean nurGanzeWoerter, JEditorPane editorPane) {
        int start = editorPane.getSelectionStart();
        int laenge = editorPane.getSelectionEnd() - start;
        if (laenge > 0 && start > 0) {
            this.doReplace(suchStr, ersetzStr, start, laenge, grossKlein, nurGanzeWoerter);
        }
    }

    private boolean doFindRange(Pattern pattern, int start, int laenge, JEditorPane editorPane) {
        Matcher matcher = this.createMatcher(pattern, start, laenge);
        if (matcher != null && matcher.find()) {
            editorPane.select(matcher.start() + start, matcher.end() + start);
            return true;
        }
        return false;
    }

    private boolean doFindRangePrev(Pattern pattern, int start, int laenge, JEditorPane editorPane) {
        Matcher matcher;
        int dot = start + laenge;
        if (dot >= start + this.getLength()) {
            dot = start + this.getLength() - 1;
        }
        if ((matcher = this.createMatcher(pattern, start, laenge)) == null) {
            return false;
        }
        int lastBegin = -1;
        int lastEnd = -1;
        while (matcher.find()) {
            if (matcher.end() >= dot) break;
            lastBegin = matcher.start();
            lastEnd = matcher.end();
        }
        if (lastEnd > 0) {
            editorPane.select(lastBegin + start, lastEnd + start);
            return true;
        }
        return false;
    }

    public boolean doFindNext(JEditorPane editorPane) {
        if (this.searchPattern == null) {
            return false;
        }
        int start = editorPane.getSelectionEnd();
        if (editorPane.getSelectionEnd() == editorPane.getSelectionStart()) {
            ++start;
        }
        if (start >= this.getLength()) {
            start = this.getLength();
        }
        if (this.doFindRange(this.searchPattern, start, this.getLength() - start, editorPane)) {
            return true;
        }
        return this.doFindRange(this.searchPattern, 0, this.getLength(), editorPane);
    }

    public boolean doFindAll(String suchStr, boolean grossKlein, boolean nurGanzeWoerter, boolean vorwaerts, JEditorPane editorPane) {
        if (suchStr == null || suchStr.isEmpty()) {
            return false;
        }
        this.searchPattern = this.createPattern(suchStr, true, grossKlein, nurGanzeWoerter);
        if (this.searchPattern == null) {
            return false;
        }
        if (vorwaerts) {
            return this.doFindRange(this.searchPattern, 0, this.getLength(), editorPane);
        }
        return this.doFindRangePrev(this.searchPattern, 0, this.getLength(), editorPane);
    }

    public boolean doFindFromCursor(String suchStr, boolean grossKlein, boolean nurGanzeWoerter, boolean vorwaerts, JEditorPane editorPane) {
        if (suchStr == null || suchStr.isEmpty()) {
            return false;
        }
        this.searchPattern = this.createPattern(suchStr, true, grossKlein, nurGanzeWoerter);
        if (this.searchPattern == null) {
            return false;
        }
        int start = editorPane.getCaretPosition();
        if (vorwaerts) {
            return this.doFindRange(this.searchPattern, start, this.getLength() - start, editorPane);
        }
        return this.doFindRangePrev(this.searchPattern, start, this.getLength() - start, editorPane);
    }

    public boolean doFindSelected(String suchStr, boolean grossKlein, boolean nurGanzeWoerter, boolean vorwaerts, JEditorPane editorPane) {
        if (suchStr == null || suchStr.isEmpty()) {
            return false;
        }
        this.searchPattern = this.createPattern(suchStr, true, grossKlein, nurGanzeWoerter);
        if (this.searchPattern == null) {
            return false;
        }
        int start = editorPane.getSelectionStart();
        int laenge = editorPane.getSelectionEnd() - start;
        if (vorwaerts) {
            return this.doFindRange(this.searchPattern, start, laenge, editorPane);
        }
        return this.doFindRangePrev(this.searchPattern, start, laenge, editorPane);
    }

    public int getLineCount() {
        Element e = this.getDefaultRootElement();
        int cnt = e.getElementCount();
        return cnt;
    }

    public int getLineNumberAt(int pos) {
        int lineNr = this.getDefaultRootElement().getElementIndex(pos);
        return lineNr + 1;
    }

    public int getLineNumberToken(KEdtToken t) {
        int lineNr = this.getLineNumberAt(t.getStart());
        return lineNr;
    }

    public int getLineNumberCaret(JEditorPane editorPane) {
        int lineNr = this.getLineNumberAt(editorPane.getCaretPosition());
        return lineNr;
    }

    public int getBeginOfLine(int lineNr) {
        int pos = this.getDefaultRootElement().getElement(lineNr - 1).getStartOffset();
        return pos;
    }

    public int getEndOfLine(int lineNr) {
        int pos = this.getDefaultRootElement().getElement(lineNr - 1).getEndOffset();
        return pos;
    }

    public String getLineStr(int lineNr) {
        String result = "";
        int start = this.getBeginOfLine(lineNr);
        try {
            result = this.getText(start, this.getEndOfLine(lineNr) - start);
        }
        catch (BadLocationException ex) {
            return result;
        }
        return result;
    }

    public int getBeginOfLinePos(int aktPos) {
        int lineNr = this.getLineNumberAt(aktPos);
        int pos = this.getDefaultRootElement().getElement(lineNr - 1).getStartOffset();
        return pos;
    }

    public void formatieren(JEditorPane editorPane, int tabLen) {
        this.setMitParsen(false);
        int anz = this.getLineCount();
        String tabStr = null;
        String zeileStr = null;
        String testStr = null;
        String keyStr = null;
        int level = 0;
        int z = 1;
        while (z <= anz) {
            int startLine = this.getBeginOfLine(z);
            int endLine = this.getEndOfLine(z) - 1;
            int lenLine = endLine - startLine;
            if (lenLine > 0) {
                try {
                    zeileStr = this.getText(startLine, lenLine).toLowerCase();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                int p1 = 0;
                while (p1 < lenLine && zeileStr.charAt(p1) == ' ') {
                    ++p1;
                }
                int p2 = p1 + 1;
                while (p2 < lenLine && zeileStr.charAt(p2) != ' ') {
                    ++p2;
                }
                keyStr = p1 == lenLine ? "" : zeileStr.substring(p1, p2);
                testStr = "|" + keyStr + "|";
                if ("|*wenn|endewenn|*wiederhole|endewiederhole|sonst|*anweisung|endeanweisung|*methode|endemethode|*bedingung|endebedingung|*programm|endeprogramm|*einf\u00fcgen|endeeinf\u00fcgen|".contains(testStr)) {
                    --level;
                }
                tabStr = "                                     ".substring(0, level * tabLen);
                try {
                    this.remove(startLine, p1);
                    this.insertString(startLine, tabStr, null);
                }
                catch (BadLocationException ex) {
                    break;
                }
                if ("|wenn|wiederhole|sonst|anweisung|methode|bedingung|programm|einf\u00fcgen|".contains(testStr)) {
                    ++level;
                }
                if (zeileStr.contains("*" + keyStr) || zeileStr.contains("ende" + keyStr)) {
                    --level;
                }
            }
            ++z;
        }
        if (this.mitSchreibweise) {
            this.parse();
            this.highLight();
            String suchStr = null;
            String suchStrLower = null;
            String ersatzStr = null;
            String karolAllKeys = "wiederhole|mal|immer|solange|bis|falsch|wahr|nicht|wenn|dann|sonst|langsam|schnell|warten|Bedingung|Anweisung|Methode|Programm|\\*wiederhole|endewiederhole|\\*wenn|endewenn|\\*Anweisung|endeAnweisung|\\*Methode|endeMethode|\\*Bedingung|endeBedingung|\\*Programm|endeProgramm|Einf\u00fcgen|\\*Einf\u00fcgen|endeEinf\u00fcgen|Beenden|Ton|Aufheben|Hinlegen|Schritt|LinksDrehen|RechtsDrehen|MarkeSetzen|MarkeL\u00f6schen|IstLeer|IstWand|IstMarke|IstVoll|IstZiegel|IstNorden|IstOsten|IstS\u00fcden|IstWesten|HatZiegel|NichtIstLeer|NichtIstWand|NichtIstMarke|NichtIstVoll|NichtIstZiegel";
            String karolAllKeysLower = karolAllKeys.toLowerCase();
            int pos = 0;
            int suchLen = 0;
            ListIterator<KEdtToken> ti = this.tokens.listIterator();
            while (ti.hasNext()) {
                KEdtToken t = ti.next();
                KEdtToken.TokenType tt = t.getTyp();
                if (tt != KEdtToken.TokenType.KEY && tt != KEdtToken.TokenType.KEYEND && tt != KEdtToken.TokenType.KEYANW && tt != KEdtToken.TokenType.KEYBED) continue;
                suchStr = this.getString(t);
                suchStrLower = suchStr.toLowerCase();
                suchLen = suchStr.length();
                pos = karolAllKeysLower.indexOf(suchStrLower);
                if (pos < 0) continue;
                ersatzStr = karolAllKeys.substring(pos, pos + suchLen);
                this.replaceToken(t, ersatzStr);
            }
            this.parse();
            this.highLight();
        }
        this.setMitParsen(true);
    }
}

