/*
 * Decompiled with CFR 0.152.
 */
package robotkarol;

import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import karoleditor.KEdtDocument;
import karoleditor.KEdtGutter;
import karoleditor.KEdtRegexLexer;
import karoleditor.KEdtToken;
import robotkarol.KarolRoboter;
import robotkarol.KarolView;
import robotkarol.KarolWelt;

public class KarolProgram {
    private KarolWelt welt;
    private KarolRoboter karol;
    private KarolView view;
    private String defaultProgPfad = "";
    private String fileSeparator = "";
    private String progDateiname = "";
    private KEdtDocument doc;
    private Map<String, Integer> KeyMap;
    public Map<Integer, String> TokenMap;
    private List<KEdtToken> GesTokens;
    private StringBuilder GesProgramm;
    public List<KarolProgBlock> blockArray = new ArrayList<KarolProgBlock>(20);
    public List<KarolProgAnw> anwArray = new ArrayList<KarolProgAnw>(100);
    private Stack<KarolProgStack> anwStack = new Stack();
    public final String[] farbParameter = new String[]{"(rot)", "(gelb)", "(blau)", "(gr\u00fcn)", "(schwarz)"};
    private ProgStatusType progStatus;
    private ProgStatusType pauseProgStatus;
    private boolean cError = false;
    private boolean isStopped = false;
    private boolean isFast = false;
    private boolean showOnError = false;
    private boolean stopOnError = true;
    private boolean scrollOnStep = true;
    private int breakLine;
    private int progVerzoegerung = 100;
    private float progScrollPerLine = 0.0f;
    private ProgThread progThread;
    private static /* synthetic */ int[] $SWITCH_TABLE$karoleditor$KEdtToken$TokenType;

    public KarolProgram(KarolWelt w, KarolRoboter r, KarolView v) {
        this.welt = w;
        this.karol = r;
        this.view = v;
        this.doc = this.view.getProgDocument();
        this.progDateiname = "";
        this.KeyMap = new HashMap<String, Integer>(){
            {
                this.put("programm", 1);
                this.put("wiederhole", 2);
                this.put("wenn", 6);
                this.put("sonst", 8);
                this.put("anweisung", 9);
                this.put("methode", 9);
                this.put("bedingung", 10);
                this.put("wahr", 11);
                this.put("falsch", 12);
                this.put("einf\u00fcgen", 14);
                this.put("endewiederhole", 50);
                this.put("*wiederhole", 50);
                this.put("endewenn", 51);
                this.put("*wenn", 51);
                this.put("endeanweisung", 52);
                this.put("*anweisung", 52);
                this.put("endebedingung", 53);
                this.put("*bedingung", 53);
                this.put("endemethode", 52);
                this.put("*methode", 52);
                this.put("endeprogramm", 54);
                this.put("*programm", 54);
                this.put("endeeinf\u00fcgen", 55);
                this.put("*einf\u00fcgen", 55);
                this.put("schritt", 101);
                this.put("linksdrehen", 102);
                this.put("rechtsdrehen", 103);
                this.put("hinlegen", 104);
                this.put("aufheben", 105);
                this.put("markesetzen", 106);
                this.put("markel\u00f6schen", 107);
                this.put("warten", 108);
                this.put("ton", 109);
                this.put("langsam", 110);
                this.put("schnell", 111);
                this.put("beenden", 112);
                this.put("istwand", 201);
                this.put("nichtistwand", 202);
                this.put("istziegel", 203);
                this.put("nichtistziegel", 204);
                this.put("istmarke", 205);
                this.put("nichtistmarke", 206);
                this.put("istnorden", 207);
                this.put("istosten", 208);
                this.put("ists\u00fcden", 209);
                this.put("istwesten", 210);
                this.put("istvoll", 211);
                this.put("nichtistvoll", 212);
                this.put("istleer", 213);
                this.put("nichtistleer", 214);
                this.put("hatziegel", 215);
            }
        };
        this.TokenMap = new HashMap<Integer, String>(){
            {
                this.put(1, "Programm");
                this.put(2, "wiederhole");
                this.put(3, "mal");
                this.put(4, "solange");
                this.put(6, "wenn");
                this.put(7, "dann");
                this.put(8, "sonst");
                this.put(9, "Anweisung");
                this.put(10, "Bedingung");
                this.put(11, "wahr");
                this.put(12, "falsch");
                this.put(13, "nicht");
                this.put(14, "Einf\u00fcgen");
                this.put(15, "bis");
                this.put(16, "immer");
                this.put(50, "*wiederhole");
                this.put(51, "*wenn");
                this.put(52, "*Anweisung");
                this.put(53, "*Bedingung");
                this.put(54, "*Programm");
                this.put(55, "*Einf\u00fcgen");
                this.put(101, "Schritt");
                this.put(102, "LinksDrehen");
                this.put(103, "RechtsDrehen");
                this.put(104, "Hinlegen");
                this.put(105, "Aufheben");
                this.put(106, "MarkeSetzen");
                this.put(107, "MarkeL\u00f6schen");
                this.put(108, "Warten");
                this.put(109, "Ton");
                this.put(110, "Langsam");
                this.put(111, "Schnell");
                this.put(112, "Beenden");
                this.put(201, "IstWand");
                this.put(202, "NichtIstWand");
                this.put(203, "IstZiegel");
                this.put(204, "NichtIstZiegel");
                this.put(205, "IstMarke");
                this.put(206, "NichtIstMarke");
                this.put(207, "IstNorden");
                this.put(208, "IstOsten");
                this.put(209, "IstS\u00fcden");
                this.put(210, "IstWesten");
                this.put(211, "IstVoll");
                this.put(212, "NichtIstVoll");
                this.put(213, "IstLeer");
                this.put(214, "NichtIstLeer");
                this.put(215, "HatZiegel");
            }
        };
        this.view.getStruktoPanel().setProgram(this);
        this.cError = false;
        this.GesTokens = new ArrayList<KEdtToken>(700);
        this.GesProgramm = new StringBuilder(1000);
        this.progStatus = ProgStatusType.PStNothing;
        this.pauseProgStatus = null;
    }

    public void setDefaultProgPfadSep(String s, String f) {
        this.defaultProgPfad = s;
        this.fileSeparator = f;
    }

    public void setDefaultProgPfad(String s) {
        this.defaultProgPfad = s;
        this.welt.setDefaultWeltPfad(s);
    }

    public String getDefaultProgPfad() {
        return this.defaultProgPfad;
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public String getProgDateiname() {
        return this.progDateiname;
    }

    public int getProgVerzoegerung() {
        return this.progVerzoegerung;
    }

    public void setProgVerzoegerung(int vz) {
        this.progVerzoegerung = vz;
    }

    public ProgStatusType getProgStatus() {
        return this.progStatus;
    }

    public boolean getStopOnError() {
        return this.stopOnError;
    }

    public boolean getShowOnError() {
        return this.showOnError;
    }

    public void setOnError(boolean show, boolean stop) {
        this.showOnError = show;
        this.stopOnError = stop;
    }

    public boolean getScrollOnStep() {
        return this.scrollOnStep;
    }

    public void setScrollOnStep(boolean scroll) {
        this.scrollOnStep = scroll;
    }

    public boolean newProgFile() {
        if (this.view.getProgDocument().getModified() && JOptionPane.showConfirmDialog(null, "Das aktuelle Programm wurde ge\u00e4ndert.\nOhne Speichern gehen die \u00c4nderungen verloren.\n\nTrotzdem neues Programm anlegen?", "Best\u00e4tigung", 0, 2) == 1) {
            return false;
        }
        this.view.getGutterPanel().setAllMarkerInvisible();
        this.view.getProgTextPanel().setText("");
        this.view.getProgDocument().resetModified();
        this.progDateiname = "";
        this.view.InfoBoxSetProgrammName(this.progDateiname);
        this.view.getProgTextPanel().setCaretPosition(0);
        return true;
    }

    public boolean openProgFile(String fileNameProg, boolean mitWelt) {
        String fileNameWelt = "";
        String content = "";
        String vorschlag = "";
        if (this.view.getProgDocument().getModified() && JOptionPane.showConfirmDialog(null, "Das aktuelle Programm wurde ge\u00e4ndert.\nOhne Speichern gehen die \u00c4nderungen verloren.\n\nTrotzdem neues Programm \u00f6ffnen?", "Best\u00e4tigung", 0, 2) == 1) {
            return false;
        }
        if (fileNameProg.isEmpty()) {
            vorschlag = this.defaultProgPfad;
            if (!this.progDateiname.isEmpty()) {
                vorschlag = Paths.get(this.progDateiname, new String[0]).getParent().toString();
            }
            fileNameProg = this.view.dlgOpenSave.dateiVorhanden(this.view.dlgOpenSave.dateiOeffnen(vorschlag, 'p'), 'p');
        } else {
            fileNameProg = this.view.dlgOpenSave.dateiVorhanden(fileNameProg, 'p');
        }
        if (fileNameProg.isEmpty()) {
            JOptionPane.showMessageDialog(null, "Keine Karolprogramm-Datei ausgew\u00e4hlt", "KarolProgramm \u00f6ffnen", 0);
            return false;
        }
        this.view.getGutterPanel().setAllMarkerInvisible();
        try {
            content = new String(Files.readAllBytes(Paths.get(fileNameProg, new String[0])), StandardCharsets.ISO_8859_1);
        }
        catch (IOException ioex) {
            return false;
        }
        this.view.getProgTextPanel().setText(content);
        this.progDateiname = fileNameProg;
        this.view.InfoBoxSetProgrammName(this.progDateiname);
        this.view.getProgDocument().resetModified();
        this.setDefaultProgPfad(Paths.get(this.progDateiname, new String[0]).getParent().toString());
        fileNameWelt = String.valueOf(fileNameProg.substring(0, fileNameProg.lastIndexOf("."))) + ".kdw";
        File f = new File(fileNameWelt);
        if (f.exists() && f.isFile() && mitWelt) {
            this.welt.loadKarolWelt(fileNameWelt);
            if (this.view.getViewStatus() == KarolView.DisplayStatusType.VST_3D) {
                this.view.getWelt3DPanel().resetWeltAnzeige();
            }
            if (this.view.getViewStatus() == KarolView.DisplayStatusType.VST_2D) {
                this.view.getWelt2DPanel().resetWeltAnzeige();
            }
            this.view.InfoBoxSetWeltName(fileNameWelt);
        }
        this.view.getProgTextPanel().requestFocus();
        this.view.getProgTextPanel().setCaretPosition(0);
        return true;
    }

    public void saveProgFile() {
        if (this.progDateiname.isEmpty()) {
            this.saveAsProgFile();
        }
        String content = this.view.getProgTextPanel().getText();
        try {
            Files.write(Paths.get(this.progDateiname, new String[0]), content.getBytes(StandardCharsets.ISO_8859_1), new OpenOption[0]);
        }
        catch (IOException ex) {
            return;
        }
        this.view.getProgDocument().resetModified();
    }

    public boolean saveAsProgFile() {
        String fileNameProg = "";
        String vorschlag = "";
        vorschlag = !this.progDateiname.isEmpty() ? this.progDateiname : this.defaultProgPfad;
        fileNameProg = this.view.dlgOpenSave.dateiSpeichernUnter(vorschlag, 'p');
        if (fileNameProg.isEmpty()) {
            return false;
        }
        String content = this.view.getProgTextPanel().getText();
        try {
            Files.write(Paths.get(fileNameProg, new String[0]), content.getBytes(StandardCharsets.ISO_8859_1), new OpenOption[0]);
        }
        catch (IOException ex) {
            return false;
        }
        this.view.getProgDocument().resetModified();
        this.progDateiname = fileNameProg;
        this.view.InfoBoxSetProgrammName(this.progDateiname);
        this.view.getProgTextPanel().setCaretPosition(0);
        this.setDefaultProgPfad(Paths.get(this.progDateiname, new String[0]).getParent().toString());
        return true;
    }

    public void printProg() {
        File f = new File(this.progDateiname);
        String strDate = MessageFormat.format("{0, date,long}", new Date());
        MessageFormat header = new MessageFormat("KarolProgramm " + f.getName());
        MessageFormat footer = new MessageFormat("gedruckt am " + strDate);
        try {
            this.view.getProgTextPanel().print(header, footer);
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
    }

    private int searchBlockArray(String bez, byte t) {
        int i = 0;
        while (i < this.blockArray.size()) {
            if (this.blockArray.get((int)i).bezeichner.equalsIgnoreCase(bez) && t == this.blockArray.get((int)i).typ) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getBedingung(int tokPos, KarolProgAnw progAnw, int fehlerNr) {
        int ergeb = -1;
        int blockNr = 0;
        KEdtToken tok = null;
        Object[] nichtZahl = new Integer[]{201, 202, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214};
        Object[] nichtFarbe = new Integer[]{201, 202, 207, 208, 209, 210, 211, 212, 213, 214, 215};
        progAnw.paramI = 0;
        progAnw.paramB = false;
        progAnw.bedNr = 0;
        if (tokPos >= this.GesTokens.size()) {
            this.CErrorProc(fehlerNr, progAnw.lineNum);
            return -1;
        }
        tok = this.GesTokens.get(tokPos);
        if (tok.getTyp() == KEdtToken.TokenType.KEY && this.getStringLower(tok).equals("nicht")) {
            progAnw.paramB = true;
            if (++tokPos >= this.GesTokens.size()) {
                this.CErrorProc(fehlerNr, progAnw.lineNum);
                return -1;
            }
            tok = this.GesTokens.get(tokPos);
        }
        if (tok.getTyp() == KEdtToken.TokenType.KAROL) {
            if (++tokPos >= this.GesTokens.size()) {
                this.CErrorProc(fehlerNr, progAnw.lineNum);
                return -1;
            }
            tok = this.GesTokens.get(tokPos);
        }
        if (tok.getTyp() == KEdtToken.TokenType.KEYBED) {
            progAnw.bedNr = this.KeyMap.get(this.getStringLower(tok));
        }
        if (tok.getTyp() == KEdtToken.TokenType.IDENTIFIER) {
            blockNr = this.searchBlockArray(this.getStringLower(tok), (byte)2);
            if (blockNr < 0) {
                this.CErrorProc(11, progAnw.lineNum);
                return -1;
            }
            progAnw.bedNr = 400 + blockNr;
        }
        if (progAnw.bedNr == 0) {
            this.CErrorProc(fehlerNr, progAnw.lineNum);
            return -1;
        }
        if (++tokPos >= this.GesTokens.size()) {
            return tokPos - 1;
        }
        tok = this.GesTokens.get(tokPos);
        if (tok.getTyp() == KEdtToken.TokenType.PEMPTY) {
            return tokPos;
        }
        if (tok.getTyp() == KEdtToken.TokenType.PNUMBER) {
            String tokStr = this.getStringLower(tok);
            ergeb = Integer.valueOf(tokStr.substring(1, tokStr.length() - 1));
            if (ergeb <= 0) {
                this.CErrorProc(13, progAnw.lineNum);
                return -1;
            }
            if (Arrays.binarySearch(nichtZahl, (Object)progAnw.bedNr) >= 0 || progAnw.bedNr >= 400) {
                this.CErrorProc(54, progAnw.lineNum);
                return -1;
            }
            progAnw.paramI = ergeb;
            return tokPos;
        }
        if (tok.getTyp() == KEdtToken.TokenType.PCOLOR) {
            String tokStr = this.getStringLower(tok);
            ergeb = Arrays.asList(this.farbParameter).indexOf(tokStr) + 1;
            if (ergeb <= 0) {
                this.CErrorProc(38, progAnw.lineNum);
                return -1;
            }
            if (Arrays.binarySearch(nichtFarbe, (Object)progAnw.bedNr) >= 0 || progAnw.bedNr >= 400) {
                this.CErrorProc(55, progAnw.lineNum);
                return -1;
            }
            progAnw.paramI = -ergeb;
            return tokPos;
        }
        return tokPos - 1;
    }

    private int getParameter(int tokPos, KarolProgAnw progAnw) {
        int ergeb = -1;
        KEdtToken tok = null;
        Object[] nichtZahl = new Integer[]{9, 10, 102, 103, 106, 107, 109, 110, 111, 112};
        Object[] nichtFarbe = new Integer[]{9, 10, 101, 102, 103, 105, 107, 108, 109, 110, 111, 112};
        progAnw.paramI = 1;
        if (progAnw.schluesselNr == 108) {
            progAnw.paramI = 1000;
        }
        progAnw.paramB = false;
        progAnw.bedNr = 0;
        if (tokPos >= this.GesTokens.size()) {
            return tokPos - 1;
        }
        tok = this.GesTokens.get(tokPos);
        if (tok.getTyp() == KEdtToken.TokenType.PEMPTY) {
            return tokPos;
        }
        if (tok.getTyp() == KEdtToken.TokenType.PNUMBER) {
            String tokStr = this.getStringLower(tok);
            ergeb = Integer.valueOf(tokStr.substring(1, tokStr.length() - 1));
            if (ergeb <= 0) {
                this.CErrorProc(13, progAnw.lineNum);
                return -1;
            }
            if (Arrays.binarySearch(nichtZahl, (Object)progAnw.schluesselNr) >= 0 || progAnw.schluesselNr >= 300) {
                this.CErrorProc(56, progAnw.lineNum);
                return -1;
            }
            progAnw.paramI = ergeb;
            return tokPos;
        }
        if (tok.getTyp() == KEdtToken.TokenType.PCOLOR) {
            String tokStr = this.getStringLower(tok);
            ergeb = Arrays.asList(this.farbParameter).indexOf(tokStr) + 1;
            if (ergeb <= 0) {
                this.CErrorProc(38, progAnw.lineNum);
                return -1;
            }
            if (Arrays.binarySearch(nichtFarbe, (Object)progAnw.schluesselNr) >= 0 || progAnw.schluesselNr >= 300) {
                this.CErrorProc(57, progAnw.lineNum);
                return -1;
            }
            progAnw.paramI = -ergeb;
            return tokPos;
        }
        return tokPos - 1;
    }

    private boolean between(int x, int a, int b) {
        return a <= x && x <= b;
    }

    /*
     * Unable to fully structure code
     */
    boolean compileProgramm() {
        if (this.progStatus != ProgStatusType.PStNothing) {
            return false;
        }
        this.view.InfoBoxLoeschen();
        this.view.getGutterPanel().setAllMarkerInvisible();
        this.view.ProgrammLampeSchalten(ProgStatusType.PStNothing);
        this.anwArray.clear();
        this.blockArray.clear();
        this.anwStack.clear();
        this.cError = false;
        if (!this.prepareProgramm()) {
            return false;
        }
        maxGesTokens = this.GesTokens.size();
        aktTok = null;
        nextTok = null;
        nextNextTok = null;
        aktTyp = KEdtToken.TokenType.DEFAULT;
        nextTyp = KEdtToken.TokenType.DEFAULT;
        nextStr = "";
        tempProgAnw = null;
        keyNr = 0;
        nextKeyNr = 0;
        aktLine = 0;
        paramI = 0;
        anwNr = 0;
        nextPos = 0;
        tempInt = 0;
        tempIntValue = null;
        inAnwDef = false;
        inBedDef = false;
        inProgDef = false;
        hatWahrFalsch = false;
        this.blockArray.add(new KarolProgBlock(0, "KarolProgramm", 1, 0));
        this.anwArray.add(new KarolProgAnw(1, 0, 0, false, 0, 1));
        aktPos = 0;
        while (aktPos < maxGesTokens && !this.cError) {
            aktTok = this.GesTokens.get(aktPos);
            aktTyp = aktTok.getTyp();
            aktLine = aktTok.getDocLineNr();
            keyNr = 0;
            switch (KarolProgram.$SWITCH_TABLE$karoleditor$KEdtToken$TokenType()[aktTyp.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    tempIntValue = this.KeyMap.get(this.getStringLower(aktTok));
                    if (tempIntValue == null) {
                        this.CErrorProc(67, aktLine);
                        break;
                    }
                    keyNr = tempIntValue;
                    ** GOTO lbl65
                }
                case 12: {
                    keyNr = 500;
                    ** GOTO lbl65
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    this.CErrorProc(35, aktLine);
                    break;
                }
                case 13: {
                    this.CErrorProc(61, aktLine);
                    break;
                }
                case 15: {
                    break;
                }
                case 14: {
                    keyNr = 300;
                }
lbl65:
                // 4 sources

                default: {
                    if (keyNr == 0) {
                        this.CErrorProc(10, aktLine);
                        break;
                    }
                    if (!(inAnwDef || inBedDef || inProgDef || keyNr != 2 && keyNr != 6 && !this.between(keyNr, 101, 112) && !this.between(keyNr, 300, 399))) {
                        bl = this.blockArray.get(0);
                        bl.beginn = this.anwArray.size();
                        this.anwStack.push(new KarolProgStack(1, 0));
                        this.anwArray.add(new KarolProgAnw(1, 0, 0, false, 0, aktLine));
                        inProgDef = true;
                    }
                    if (keyNr == 1) {
                        if (inAnwDef || inBedDef) {
                            this.CErrorProc(21, aktLine);
                            break;
                        }
                        bl = this.blockArray.get(0);
                        bl.beginn = this.anwArray.size();
                        this.anwStack.push(new KarolProgStack(1, 0));
                        this.anwArray.add(new KarolProgAnw(1, 0, 0, false, 0, aktLine));
                        inProgDef = true;
                    }
                    if (keyNr == 300) {
                        anwNr = this.searchBlockArray(this.getStringLower(aktTok), (byte)1);
                        if (anwNr < 0) {
                            this.CErrorProc(10, aktLine);
                            break;
                        }
                        tempProgAnw = new KarolProgAnw(300 + anwNr, 0, 0, false, this.blockArray.get((int)anwNr).beginn, aktLine);
                        nextPos = this.getParameter(aktPos + 1, tempProgAnw);
                        if (nextPos < 0 || this.cError) break;
                        aktPos = nextPos;
                        tempProgAnw.paramI = 0;
                        this.anwArray.add(tempProgAnw);
                        break;
                    }
                    if (this.between(keyNr, 101, 112)) {
                        tempProgAnw = new KarolProgAnw(keyNr, 0, 0, false, 0, aktLine);
                        nextPos = this.getParameter(aktPos + 1, tempProgAnw);
                        if (nextPos < 0 || this.cError) break;
                        if (keyNr == 104 && tempProgAnw.paramI == -5) {
                            this.CErrorProc(34, tempProgAnw.lineNum);
                            break;
                        }
                        aktPos = nextPos;
                        this.anwArray.add(tempProgAnw);
                        break;
                    }
                    if (keyNr == 2) {
                        if (aktPos + 1 < maxGesTokens) {
                            nextTok = this.GesTokens.get(aktPos + 1);
                            nextTyp = nextTok.getTyp();
                            nextStr = this.getStringLower(nextTok);
                            if (nextTyp == KEdtToken.TokenType.KEY) {
                                if (nextStr.equals("immer")) {
                                    ++aktPos;
                                    this.anwStack.push(new KarolProgStack(5, this.anwArray.size()));
                                    this.anwArray.add(new KarolProgAnw(5, 0, 0x7FFFFFFF, false, 0, aktLine));
                                    break;
                                }
                                if (nextStr.equals("solange")) {
                                    tempProgAnw = new KarolProgAnw(4, 0, 0, false, 0, aktLine);
                                    if ((nextPos = this.getBedingung(++aktPos + 1, tempProgAnw, 15)) < 0 || this.cError) break;
                                    aktPos = nextPos;
                                    this.anwStack.push(new KarolProgStack(4, this.anwArray.size()));
                                    this.anwArray.add(tempProgAnw);
                                    break;
                                }
                                if (nextStr.equals("mal")) {
                                    this.CErrorProc(19, aktLine);
                                    break;
                                }
                            }
                            if (nextTyp == KEdtToken.TokenType.NUMBER) {
                                if (++aktPos + 1 >= maxGesTokens) {
                                    this.CErrorProc(4, aktLine);
                                    break;
                                }
                                nextNextTok = this.GesTokens.get(aktPos + 1);
                                if (!this.getStringLower(nextNextTok).equals("mal")) {
                                    this.CErrorProc(4, aktLine);
                                    break;
                                }
                                paramI = Integer.valueOf(nextStr);
                                if (paramI <= 0) {
                                    this.CErrorProc(13, aktLine);
                                    break;
                                }
                                ++aktPos;
                                this.anwStack.push(new KarolProgStack(3, this.anwArray.size()));
                                this.anwArray.add(new KarolProgAnw(3, 0, paramI, false, 0, aktLine));
                                break;
                            }
                        }
                        this.anwStack.push(new KarolProgStack(2, this.anwArray.size()));
                        this.anwArray.add(new KarolProgAnw(2, 0, 0, false, 0, aktLine));
                        break;
                    }
                    if (keyNr == 6) {
                        tempProgAnw = new KarolProgAnw(6, 0, 0, false, 0, aktLine);
                        nextPos = this.getBedingung(aktPos + 1, tempProgAnw, 2);
                        if (nextPos < 0 || this.cError) break;
                        aktPos = nextPos;
                        if (aktPos + 1 >= maxGesTokens) {
                            this.CErrorProc(2, aktLine);
                            break;
                        }
                        nextTok = this.GesTokens.get(aktPos + 1);
                        nextTyp = nextTok.getTyp();
                        nextStr = this.getStringLower(nextTok);
                        if (nextTyp != KEdtToken.TokenType.KEY || !nextStr.equals("dann")) {
                            this.CErrorProc(2, aktLine);
                            break;
                        }
                        ++aktPos;
                        this.anwStack.push(new KarolProgStack(6, this.anwArray.size()));
                        this.anwArray.add(tempProgAnw);
                        break;
                    }
                    if (keyNr == 9) {
                        if (inAnwDef) {
                            this.CErrorProc(22, aktLine);
                            break;
                        }
                        if (inProgDef) {
                            this.CErrorProc(29, aktLine);
                            break;
                        }
                        if (aktPos + 1 >= maxGesTokens) {
                            this.CErrorProc(42, aktLine);
                            break;
                        }
                        nextTok = this.GesTokens.get(aktPos + 1);
                        nextTyp = nextTok.getTyp();
                        nextStr = this.getString(nextTok);
                        if (nextTyp != KEdtToken.TokenType.IDENTIFIER) {
                            this.CErrorProc(42, aktLine);
                            break;
                        }
                        anwNr = this.searchBlockArray(nextStr, (byte)1);
                        if (anwNr >= 0) {
                            this.CErrorProc(43, aktLine);
                            break;
                        }
                        ++aktPos;
                        anwNr = this.blockArray.size();
                        inAnwDef = true;
                        this.anwStack.push(new KarolProgStack(9, this.blockArray.size()));
                        this.blockArray.add(new KarolProgBlock(1, nextStr, this.anwArray.size(), 0));
                        tempProgAnw = new KarolProgAnw(9, 0, 0, false, 0, aktLine);
                        nextPos = this.getParameter(aktPos + 1, tempProgAnw);
                        if (nextPos < 0 || this.cError) break;
                        aktPos = nextPos;
                        tempProgAnw.paramI = 0;
                        this.anwArray.add(tempProgAnw);
                        break;
                    }
                    if (keyNr == 10) {
                        if (inBedDef) {
                            this.CErrorProc(23, aktLine);
                            break;
                        }
                        if (aktPos + 1 >= maxGesTokens) {
                            this.CErrorProc(44, aktLine);
                            break;
                        }
                        nextTok = this.GesTokens.get(aktPos + 1);
                        nextTyp = nextTok.getTyp();
                        nextStr = this.getString(nextTok);
                        if (nextTyp != KEdtToken.TokenType.IDENTIFIER) {
                            this.CErrorProc(44, aktLine);
                            break;
                        }
                        anwNr = this.searchBlockArray(nextStr, (byte)2);
                        if (anwNr >= 0) {
                            this.CErrorProc(45, aktLine);
                            break;
                        }
                        ++aktPos;
                        anwNr = this.blockArray.size();
                        inBedDef = true;
                        hatWahrFalsch = false;
                        this.anwStack.push(new KarolProgStack(10, this.blockArray.size()));
                        this.blockArray.add(new KarolProgBlock(2, nextStr, this.anwArray.size(), 0));
                        tempProgAnw = new KarolProgAnw(10, 0, 0, false, 0, aktLine);
                        nextPos = this.getParameter(aktPos + 1, tempProgAnw);
                        if (nextPos < 0 || this.cError) break;
                        aktPos = nextPos;
                        tempProgAnw.paramI = 0;
                        this.anwArray.add(tempProgAnw);
                        break;
                    }
                    if (keyNr == 14) {
                        if (inAnwDef) {
                            this.CErrorProc(58, aktLine);
                            break;
                        }
                        if (inProgDef) {
                            this.CErrorProc(59, aktLine);
                            break;
                        }
                        if (aktPos + 1 >= maxGesTokens) {
                            this.CErrorProc(60, aktLine);
                            break;
                        }
                        nextTok = this.GesTokens.get(aktPos + 1);
                        nextTyp = nextTok.getTyp();
                        nextStr = this.getString(nextTok);
                        if (nextTyp != KEdtToken.TokenType.FILENAME) {
                            this.CErrorProc(60, aktLine);
                            break;
                        }
                        ++aktPos;
                        break;
                    }
                    if (keyNr == 8) {
                        wennStack = this.anwStack.peek();
                        if (wennStack.schluesselNr != 6) {
                            this.CErrorProc(3, aktLine);
                            break;
                        }
                        wennAnw = this.anwArray.get(wennStack.anwArrayIndex);
                        wennAnw.geheZu = this.anwArray.size();
                        wennAnw.schluesselNr = 7;
                        this.anwStack.push(new KarolProgStack(8, this.anwArray.size()));
                        this.anwArray.add(new KarolProgAnw(8, 0, 0, false, 0, aktLine));
                        break;
                    }
                    if (keyNr == 11 || keyNr == 12) {
                        if (!inBedDef) {
                            this.CErrorProc(46, aktLine);
                            break;
                        }
                        hatWahrFalsch = true;
                        this.anwArray.add(new KarolProgAnw(keyNr, 0, 0, false, 0, aktLine));
                        break;
                    }
                    if (keyNr == 500) {
                        if (aktPos + 1 >= maxGesTokens) {
                            this.CErrorProc(28, aktLine);
                            break;
                        }
                        nextTok = this.GesTokens.get(aktPos + 1);
                        nextTyp = nextTok.getTyp();
                        if (nextTyp == KEdtToken.TokenType.KEYANW || nextTyp == KEdtToken.TokenType.KEYBED || nextTyp == KEdtToken.TokenType.IDENTIFIER) break;
                        this.CErrorProc(28, aktLine);
                        break;
                    }
                    if (keyNr == 50) {
                        if (aktPos + 1 < maxGesTokens) {
                            nextTok = this.GesTokens.get(aktPos + 1);
                            nextTyp = nextTok.getTyp();
                            nextStr = this.getStringLower(nextTok);
                            if (nextTyp == KEdtToken.TokenType.KEY && (nextStr.equals("solange") || nextStr.equals("bis"))) {
                                if (nextStr.equals("solange")) {
                                    nextKeyNr = 60;
                                    tempInt = 18;
                                } else {
                                    nextKeyNr = 61;
                                    tempInt = 17;
                                }
                                tempProgAnw = new KarolProgAnw(nextKeyNr, 0, 0, false, 0, aktLine);
                                nextPos = this.getBedingung(++aktPos + 1, tempProgAnw, tempInt);
                                if (nextPos < 0 || this.cError) break;
                                wdhStack = this.anwStack.pop();
                                if (wdhStack.schluesselNr != 2) {
                                    this.CErrorProc(47, aktLine);
                                    break;
                                }
                                wdhAnw = this.anwArray.get(wdhStack.anwArrayIndex);
                                wdhAnw.geheZu = this.anwArray.size();
                                tempProgAnw.geheZu = wdhStack.anwArrayIndex;
                                this.anwArray.add(tempProgAnw);
                                break;
                            }
                        }
                        wdhStack = this.anwStack.pop();
                        if (wdhStack.schluesselNr != 3 && wdhStack.schluesselNr != 4 && wdhStack.schluesselNr != 5) {
                            this.CErrorProc(48, aktLine);
                            break;
                        }
                        wdhAnw = this.anwArray.get(wdhStack.anwArrayIndex);
                        wdhAnw.geheZu = this.anwArray.size();
                        this.anwArray.add(new KarolProgAnw(50, 0, 0, false, wdhStack.anwArrayIndex, aktLine));
                        break;
                    }
                    if (keyNr == 51) {
                        wennStack = this.anwStack.pop();
                        if (wennStack.schluesselNr != 6 && wennStack.schluesselNr != 8) {
                            this.CErrorProc(49, aktLine);
                            break;
                        }
                        if (wennStack.schluesselNr == 6) {
                            wennAnw = this.anwArray.get(wennStack.anwArrayIndex);
                            wennAnw.geheZu = this.anwArray.size();
                            this.anwArray.add(new KarolProgAnw(51, 0, 0, false, 0, aktLine));
                            break;
                        }
                        if (wennStack.schluesselNr == 8) {
                            wennAnw = this.anwArray.get(wennStack.anwArrayIndex);
                            wennAnw.geheZu = this.anwArray.size();
                            this.anwStack.pop();
                            this.anwArray.add(new KarolProgAnw(51, 0, 0, false, 0, aktLine));
                            break;
                        }
                    }
                    if (keyNr == 52) {
                        if (!inAnwDef) {
                            this.CErrorProc(50, aktLine);
                            break;
                        }
                        defStack = this.anwStack.pop();
                        if (defStack.schluesselNr != 9) {
                            this.CErrorProc(50, aktLine);
                            break;
                        }
                        defBlock = this.blockArray.get(defStack.anwArrayIndex);
                        defBlock.ende = this.anwArray.size();
                        this.anwArray.add(new KarolProgAnw(52, 0, 0, false, 0, aktLine));
                        inAnwDef = false;
                        break;
                    }
                    if (keyNr == 53) {
                        if (!inBedDef) {
                            this.CErrorProc(51, aktLine);
                            break;
                        }
                        if (!hatWahrFalsch) {
                            this.CErrorProc(12, aktLine);
                            break;
                        }
                        defStack = this.anwStack.pop();
                        if (defStack.schluesselNr != 10) {
                            this.CErrorProc(51, aktLine);
                            break;
                        }
                        defBlock = this.blockArray.get(defStack.anwArrayIndex);
                        defBlock.ende = this.anwArray.size();
                        this.anwArray.add(new KarolProgAnw(53, 0, 0, false, 0, aktLine));
                        inBedDef = false;
                        break;
                    }
                    if (keyNr == 55 || keyNr != 54) break;
                    if (!inProgDef) {
                        this.CErrorProc(52, aktLine);
                        break;
                    }
                    defStack = this.anwStack.pop();
                    if (defStack.schluesselNr != 1) {
                        this.CErrorProc(52, aktLine);
                        break;
                    }
                    defBlock = this.blockArray.get(0);
                    defBlock.ende = this.anwArray.size();
                    this.anwArray.add(new KarolProgAnw(54, 0, 0, false, 0, aktLine));
                    inProgDef = false;
                    aktPos = maxGesTokens;
                }
            }
            ++aktPos;
        }
        if ((inAnwDef || inBedDef) && !this.cError) {
            this.CErrorProc(53, aktLine);
        }
        if (!this.cError && inProgDef) {
            if (!this.anwStack.empty()) {
                defStack = this.anwStack.pop();
                if (defStack.schluesselNr != 1) {
                    this.CErrorProc(53, aktLine);
                }
            }
            defBlock = this.blockArray.get(0);
            defBlock.ende = this.anwArray.size();
            this.anwArray.add(new KarolProgAnw(54, 0, 0, false, 0, aktLine));
            inProgDef = false;
        }
        if (this.cError) {
            this.view.ProgrammLampeSchalten(ProgStatusType.PStStop);
        } else {
            this.view.InfoBoxHinzufuegen(6, "Kein Syntaxfehler\n");
        }
        return this.cError == false;
    }

    public String getString(KEdtToken token) {
        String result = "";
        if (token != null) {
            result = this.GesProgramm.substring(token.start, token.start + token.length);
        }
        return result;
    }

    public String getStringLower(KEdtToken token) {
        return this.getString(token).toLowerCase();
    }

    public void showAllTokens() {
        if (this.GesTokens == null || this.GesTokens.isEmpty()) {
            return;
        }
        ListIterator<KEdtToken> tis = this.GesTokens.listIterator();
        while (tis.hasNext()) {
            KEdtToken t = tis.next();
            JOptionPane.showMessageDialog(null, t.toString());
        }
    }

    public void showAllTokens(List<KEdtToken> tokens) {
        if (tokens == null || tokens.isEmpty()) {
            return;
        }
        ListIterator<KEdtToken> tis = tokens.listIterator();
        while (tis.hasNext()) {
            KEdtToken t = tis.next();
            JOptionPane.showMessageDialog(null, t.toString());
        }
    }

    boolean prepareProgramm() {
        KEdtToken merkFileToken = null;
        KEdtToken merkNextToken = null;
        String libFileName = "";
        String libPfad = "";
        String progPfad = "";
        String libContent = "";
        this.GesTokens.clear();
        this.doc.getNewTokenListMitLine(this.GesTokens);
        if (this.GesTokens == null || this.GesTokens.isEmpty() || this.GesTokens.size() == 0) {
            return false;
        }
        if (this.doc.getLength() == 0) {
            return false;
        }
        try {
            this.GesProgramm.setLength(0);
            this.GesProgramm.append(this.doc.getText(0, this.doc.getLength()));
        }
        catch (BadLocationException e) {
            return false;
        }
        boolean fertig = false;
        int suchPos = 0;
        while (!fertig) {
            KEdtToken t;
            boolean gefunden = false;
            ListIterator<KEdtToken> ti = this.GesTokens.listIterator(suchPos);
            while (ti.hasNext() && !this.cError && !gefunden) {
                t = ti.next();
                if (t.getTyp() != KEdtToken.TokenType.LIB) continue;
                if (!ti.hasNext()) {
                    this.CErrorProc(60, t.getDocLineNr());
                    continue;
                }
                t = ti.next();
                if (t.getTyp() != KEdtToken.TokenType.FILENAME) {
                    this.CErrorProc(60, t.getDocLineNr());
                    continue;
                }
                merkFileToken = t;
                libFileName = this.getString(merkFileToken);
                if (!ti.hasNext()) {
                    this.CErrorProc(62, t.getDocLineNr());
                    continue;
                }
                t = ti.next();
                if (t.getTyp() != KEdtToken.TokenType.LIBEND) {
                    this.CErrorProc(62, t.getDocLineNr());
                    continue;
                }
                if (!ti.hasNext()) {
                    this.CErrorProc(66, t.getDocLineNr());
                    continue;
                }
                merkNextToken = ti.next();
                t = ti.previous();
                gefunden = true;
            }
            if (!gefunden) {
                fertig = true;
                continue;
            }
            if (!this.progDateiname.isEmpty()) {
                Path p = Paths.get(this.progDateiname, new String[0]);
                progPfad = p.getParent().toString();
            }
            libPfad = "";
            File f = new File(libFileName);
            try {
                libPfad = f.getCanonicalPath();
            }
            catch (IOException e) {
                this.CErrorProc(65, merkFileToken.getDocLineNr());
                fertig = true;
                continue;
            }
            if (!libPfad.equals(libFileName) && !progPfad.isEmpty()) {
                f = new File(progPfad, libFileName);
                try {
                    libPfad = f.getCanonicalPath();
                }
                catch (IOException e) {
                    this.CErrorProc(65, merkFileToken.getDocLineNr());
                    fertig = true;
                    continue;
                }
            }
            if (!f.exists() || !f.isFile() || libPfad.isEmpty()) {
                this.CErrorProc(63, merkFileToken.getDocLineNr());
                this.CErrorProcZus("ung\u00fcltiger Dateipfad: " + libPfad);
                fertig = true;
                continue;
            }
            libContent = "";
            try {
                libContent = new String(Files.readAllBytes(Paths.get(libPfad, new String[0])));
            }
            catch (IOException e) {
                // empty catch block
            }
            if (libContent.isEmpty()) {
                this.CErrorProc(64, merkFileToken.getDocLineNr());
                fertig = true;
                continue;
            }
            ArrayList<KEdtToken> LibTokens = new ArrayList<KEdtToken>(200);
            KEdtRegexLexer lexer = new KEdtRegexLexer();
            lexer.parse(libContent, 0, LibTokens);
            int anzZeichen = libContent.length();
            int abZeichenPos = merkNextToken.getStart();
            this.GesProgramm.insert(abZeichenPos, libContent);
            int lnr = merkFileToken.getDocLineNr();
            ListIterator til = LibTokens.listIterator();
            while (til.hasNext()) {
                t = (KEdtToken)til.next();
                t.setDocLineNr(lnr);
                t.setStart(t.getStart() + abZeichenPos);
            }
            int abTokPos = this.GesTokens.indexOf(merkNextToken);
            ListIterator<KEdtToken> tilg = this.GesTokens.listIterator(abTokPos);
            while (tilg.hasNext()) {
                t = tilg.next();
                t.setStart(t.getStart() + anzZeichen);
            }
            this.GesTokens.addAll(abTokPos, LibTokens);
            suchPos = abTokPos + LibTokens.size();
            if (suchPos < this.GesTokens.size()) continue;
            fertig = true;
        }
        return !this.cError;
    }

    public void CErrorProc(int fnr, int lnr) {
        String errorStr = "Compiler Fehler";
        switch (fnr) {
            case 1: {
                errorStr = "bed. Anweisung wenn: unbekannte oder fehlende Bedingung.";
                break;
            }
            case 2: {
                errorStr = "bed. Anweisung wenn hat die Form: wenn {bedingung} dann.";
                break;
            }
            case 3: {
                errorStr = "zweiseitige bed. Anweisung wenn: zum sonst fehlt passendes wenn. Verschachtelungsfehler!";
                break;
            }
            case 4: {
                errorStr = "Wiederholung mit fester Anzahl: nach der Zahl f\u00fcr die Wiederholungsanzahl muss das Wort mal folgen.";
                break;
            }
            case 10: {
                errorStr = "Unbekannte Anweisung/Methode. Schreibweise kontrollieren!";
                break;
            }
            case 11: {
                errorStr = "Unbekannte Bedingung. Schreibweise kontrollieren!";
                break;
            }
            case 12: {
                errorStr = "Der Bezeichner wahr oder falsch muss mindestens einmal in der selbstdef. Bedingung vorkommen.";
                break;
            }
            case 13: {
                errorStr = "Der Parameter muss eine positive Ganzzahl sein.";
                break;
            }
            case 15: {
                errorStr = "bed.Wiederholung wiederhole solange: unbekannte oder fehlende Bedingung.";
                break;
            }
            case 17: {
                errorStr = "bed.Wiederholung wiederhole  *wiederhole bis : unbekannte oder fehlende Bedingung.";
                break;
            }
            case 18: {
                errorStr = "bed.Wiederholung wiederhole  *wiederhole solange : unbekannte oder fehlende Bedingung.";
                break;
            }
            case 19: {
                errorStr = "Wiederholung mit fester Anzahl: fehlt Zahl f\u00fcr die Anzahl an Wiederholungen";
                break;
            }
            case 20: {
                errorStr = "Fehler in der Kontrollstuktur wiederhole.";
                break;
            }
            case 21: {
                errorStr = "programm ist nicht innerhalb von Anweisung/Bedingung m\u00f6glich.";
                break;
            }
            case 22: {
                errorStr = "fehlt Ende der selbstdef. Anweisung/Methode.";
                break;
            }
            case 23: {
                errorStr = "fehlt Ende der selbstdef. Bedingung.";
                break;
            }
            case 28: {
                errorStr = "Ist keine Methode des Objekts karol.";
                break;
            }
            case 29: {
                errorStr = "Anweisung/Methode und Bedingung d\u00fcrfen nur vor dem Programm definiert werden.";
                break;
            }
            case 34: {
                errorStr = "Schwarze Ziegel sind nicht m\u00f6glich.";
                break;
            }
            case 35: {
                errorStr = "Unerlaubte Verwendung von Parameter (Zahl oder Farbe).";
                break;
            }
            case 36: {
                errorStr = "Fehlt Klammer zu.";
                break;
            }
            case 37: {
                errorStr = "Bei dieser Anweisungen ist kein Parameter m\u00f6glich.";
                break;
            }
            case 38: {
                errorStr = "Diese Farbe ist unbekannt.";
                break;
            }
            case 39: {
                errorStr = "F\u00fcr diese Anweisung ist kein Parameter m\u00f6glich.";
                break;
            }
            case 40: {
                errorStr = "Als Farben sind nur rot, gelb, blau, gr\u00fcn m\u00f6glich.";
                break;
            }
            case 41: {
                errorStr = "Als Parameter sind nur Zahlen oder Farben m\u00f6glich.";
                break;
            }
            case 42: {
                errorStr = "Fehlt Bezeichner f\u00fcr die selbstdefinierte Anweisung/Methode.";
                break;
            }
            case 43: {
                errorStr = "Eine Anweisung/Methode mit diesem Namen gibt es bereits.";
                break;
            }
            case 44: {
                errorStr = "Fehlt Bezeichner f\u00fcr die selbstdefinierte Bedingung.";
                break;
            }
            case 45: {
                errorStr = "Eine Bedingung mit diesem Namen gibt es bereits.";
                break;
            }
            case 46: {
                errorStr = "Die Bezeichner wahr und falsch k\u00f6nnen nur innerhalb einer selbstdef. Bedingung verwendet werden.";
                break;
            }
            case 47: {
                errorStr = "Ende einer Wiederholung mit EndBedingung: es fehlt passendes wiederhole";
                break;
            }
            case 48: {
                errorStr = "Ende einer Wiederholung mit AnfangsBedingung: es fehlt passendes wiederhole";
                break;
            }
            case 49: {
                errorStr = "Ende bed. Anweisung *wenn: es fehlt passendes wenn bzw. sonst";
                break;
            }
            case 50: {
                errorStr = "Ende der Definition einer Anweisung/Methode ohne Kennwort anweisung/methode als Beginn. Evtl. Verschachtelungsfehler.";
                break;
            }
            case 51: {
                errorStr = "Ende der Definition einer Bedingung ohne Kennwort bedingung als Beginn. Evtl. Verschachtelungsfehler.";
                break;
            }
            case 52: {
                errorStr = "Programmende *programm ohne programm als Kennung f\u00fcr Programmbeginn. Evtl. Verschachtelungsfehler.";
                break;
            }
            case 53: {
                errorStr = "selbstdefinierte Anweisung/Methode/Bedingung wurde nicht beendet.";
                break;
            }
            case 54: {
                errorStr = "F\u00fcr diese Bedingung ist kein Zahlenparameter m\u00f6glich.";
                break;
            }
            case 55: {
                errorStr = "F\u00fcr diese Bedingung ist kein Farbenparameter m\u00f6glich.";
                break;
            }
            case 56: {
                errorStr = "F\u00fcr diese Anweisung/Methode ist kein Zahlenparameter m\u00f6glich.";
                break;
            }
            case 57: {
                errorStr = "F\u00fcr diese Anweisung/Methode ist kein Farbenparameter m\u00f6glich.";
                break;
            }
            case 58: {
                errorStr = "Einf\u00fcgen einer Bibliothek innerhalb einer Anweisung/Methode nicht m\u00f6glich.";
                break;
            }
            case 59: {
                errorStr = "Einf\u00fcgen einer Bibliothek nur vor dem Hauptprogramm m\u00f6glich.";
                break;
            }
            case 60: {
                errorStr = "Bei einf\u00fcgen einer Bibliothek fehlt Dateiname der Bibliothek.";
                break;
            }
            case 61: {
                errorStr = "Dateinamen ohne einf\u00fcgen sind nicht zul\u00e4ssig.";
                break;
            }
            case 62: {
                errorStr = "Bei einf\u00fcgen fehlt der Abschluss durch *einf\u00fcgen bzw. endeeinf\u00fcgen.";
                break;
            }
            case 63: {
                errorStr = "Die bei einf\u00fcgen angef\u00fchrte Datei existiert nicht.";
                break;
            }
            case 64: {
                errorStr = "Die angegebene Bibliotheksdatei ist leer.";
                break;
            }
            case 65: {
                errorStr = "Ung\u00fcltige Pfadangabe f\u00fcr die Bibliotheksdatei.";
                break;
            }
            case 66: {
                errorStr = "Nach dem *einf\u00fcgen bzw. endeeinf\u00fcgen fehlt ein Hauptprogramm";
                break;
            }
            case 67: {
                errorStr = "Schl\u00fcsselwort der Sprache Karol in falschem Zusammenhang verwendet.";
            }
        }
        this.cError = true;
        errorStr = "[Fehlernr " + String.valueOf(fnr) + "][Zeile " + String.valueOf(lnr) + "] " + errorStr + "\n";
        this.view.InfoBoxHinzufuegen(6, errorStr);
        this.view.getGutterPanel().setMarkerToLine(KEdtGutter.MarkerType.ALERT, lnr);
    }

    public void CErrorProcZus(String errorStr) {
        if (errorStr.isEmpty()) {
            errorStr = "Compiler Fehler";
        }
        this.cError = true;
        this.view.InfoBoxHinzufuegen(7, String.valueOf(errorStr) + "\n");
    }

    public void showAllProg() {
        int zaehler = 0;
        JOptionPane.showMessageDialog(null, "Karol Programm");
        JOptionPane.showMessageDialog(null, "AnweisungsAnzahl: " + Integer.toString(this.anwArray.size()));
        if (this.anwArray == null || this.anwArray.isEmpty()) {
            return;
        }
        ListIterator<KarolProgAnw> pi = this.anwArray.listIterator();
        while (pi.hasNext()) {
            KarolProgAnw p = pi.next();
            JOptionPane.showMessageDialog(null, "Anweisung " + Integer.toString(++zaehler) + "\n" + p.toString());
        }
    }

    public void showAllStack() {
        JOptionPane.showMessageDialog(null, "Karol Stack");
        if (this.anwStack == null || this.anwStack.isEmpty()) {
            return;
        }
        ListIterator si = this.anwStack.listIterator();
        while (si.hasNext()) {
            KarolProgStack s = (KarolProgStack)si.next();
            JOptionPane.showMessageDialog(null, s.toString());
        }
    }

    public void runProgramm(ProgStatusType prgStat) {
        if (this.progThread != null && this.progThread.isAlive()) {
            return;
        }
        if (!this.compileProgramm()) {
            return;
        }
        this.progStatus = prgStat;
        this.view.getGutterPanel().setAllMarkerInvisible();
        this.view.ProgrammLampeSchalten(this.progStatus);
        this.isStopped = false;
        this.isFast = false;
        this.karol.VerzoegerungSetzen(0);
        this.karol.clearFehlerText();
        this.karol.setRucksackAnzahl(this.karol.getRucksackStart());
        this.breakLine = this.view.getGutterPanel().getBreakPointLine();
        this.progThread = new ProgThread();
        this.progThread.start();
    }

    private void setRunMarker(int line) {
        if (this.progStatus != ProgStatusType.PStRunningFast) {
            this.view.getGutterPanel().setMarkerToLine(KEdtGutter.MarkerType.TRACE, line);
        }
    }

    private void doDelay() {
        if (this.progStatus == ProgStatusType.PStRunning && !this.isFast) {
            try {
                Thread.sleep(this.progVerzoegerung);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWait() {
        if (this.progStatus == ProgStatusType.PStTracing) {
            if (this.scrollOnStep) {
                this.scrollProgrammText();
            }
            ProgThread progThread = this.progThread;
            synchronized (progThread) {
                try {
                    this.progThread.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean runBedingung(KarolProgAnw bedAnw) {
        boolean ergeb = true;
        KarolProgBlock bedBlock = null;
        switch (bedAnw.bedNr) {
            case 201: {
                ergeb = this.karol.IstWand();
                break;
            }
            case 202: {
                ergeb = !this.karol.IstWand();
                break;
            }
            case 203: {
                ergeb = this.karol.IstZiegel(bedAnw.paramI);
                break;
            }
            case 204: {
                ergeb = !this.karol.IstZiegel(bedAnw.paramI);
                break;
            }
            case 205: {
                ergeb = this.karol.IstMarke(bedAnw.paramI);
                break;
            }
            case 206: {
                ergeb = !this.karol.IstMarke(bedAnw.paramI);
                break;
            }
            case 207: {
                ergeb = this.karol.IstBlickNorden();
                break;
            }
            case 208: {
                ergeb = this.karol.IstBlickOsten();
                break;
            }
            case 209: {
                ergeb = this.karol.IstBlickSueden();
                break;
            }
            case 210: {
                ergeb = this.karol.IstBlickWesten();
                break;
            }
            case 211: {
                ergeb = this.karol.IstRucksackVoll();
                break;
            }
            case 212: {
                ergeb = !this.karol.IstRucksackVoll();
                break;
            }
            case 213: {
                ergeb = this.karol.IstRucksackLeer();
                break;
            }
            case 214: {
                ergeb = !this.karol.IstRucksackLeer();
                break;
            }
            case 215: {
                ergeb = this.karol.HatZiegel(bedAnw.paramI);
            }
        }
        if (bedAnw.bedNr > 400 && bedAnw.bedNr < 500) {
            bedBlock = this.blockArray.get(bedAnw.bedNr - 400);
            this.runBereich(bedBlock.beginn + 1, bedBlock.ende - 1, bedAnw.bedNr - 400);
            ergeb = bedBlock.result;
        }
        if (!this.karol.getFehlerText().isEmpty() && (this.stopOnError || this.showOnError)) {
            this.RunErrorProc(bedAnw.lineNum, this.stopOnError);
            this.isStopped = this.stopOnError;
        }
        if (this.progThread.isInterrupted()) {
            this.isStopped = true;
        }
        if (bedAnw.paramB) {
            ergeb = !ergeb;
        }
        return ergeb;
    }

    private void boolEintragen(boolean wert, int blockNr) {
        if (blockNr < this.blockArray.size() && this.blockArray.get((int)blockNr).typ == 2) {
            this.blockArray.get((int)blockNr).result = wert;
        }
    }

    private void runBereich(int startAnw, int endAnw, int blockNr) {
        int posAnw = startAnw;
        KarolProgAnw aktAnw = null;
        KarolProgBlock anwBlock = null;
        boolean bTemp = false;
        while (posAnw <= endAnw && posAnw < this.anwArray.size() && !this.isStopped) {
            if (this.anwArray.get((int)posAnw).schluesselNr == 1) {
                ++posAnw;
                continue;
            }
            if (this.anwArray.get((int)posAnw).schluesselNr == 54) {
                ++posAnw;
                continue;
            }
            aktAnw = this.anwArray.get(posAnw);
            int aktParamI = aktAnw.paramI;
            if (this.breakLine == aktAnw.lineNum) {
                this.progStatus = ProgStatusType.PStTracing;
                this.view.ProgrammLampeSchalten(this.progStatus);
            }
            this.setRunMarker(aktAnw.lineNum);
            this.doWait();
            switch (aktAnw.schluesselNr) {
                case 101: {
                    this.karol.Schritt(aktParamI);
                    break;
                }
                case 102: {
                    this.karol.LinksDrehen();
                    break;
                }
                case 103: {
                    this.karol.RechtsDrehen();
                    break;
                }
                case 104: {
                    this.karol.Hinlegen(aktParamI);
                    break;
                }
                case 105: {
                    this.karol.Aufheben(aktParamI);
                    break;
                }
                case 106: {
                    this.karol.MarkeSetzen(aktParamI);
                    break;
                }
                case 107: {
                    this.karol.MarkeLoeschen();
                    break;
                }
                case 108: {
                    this.karol.Warten(aktParamI);
                    break;
                }
                case 109: {
                    this.karol.TonErzeugen();
                    break;
                }
                case 110: {
                    this.isFast = false;
                    break;
                }
                case 111: {
                    this.isFast = true;
                    break;
                }
                case 112: {
                    this.isStopped = true;
                    this.isFast = false;
                    break;
                }
                case 11: {
                    this.boolEintragen(true, blockNr);
                    break;
                }
                case 12: {
                    this.boolEintragen(false, blockNr);
                    break;
                }
                case 3: 
                case 5: {
                    int w = 1;
                    while (w <= aktParamI) {
                        this.runBereich(posAnw + 1, aktAnw.geheZu, blockNr);
                        this.setRunMarker(aktAnw.lineNum);
                        this.doWait();
                        if (this.isStopped) break;
                        ++w;
                    }
                    posAnw = aktAnw.geheZu;
                    break;
                }
                case 4: {
                    while (this.runBedingung(aktAnw) && !this.isStopped) {
                        this.runBereich(posAnw + 1, aktAnw.geheZu, blockNr);
                        this.setRunMarker(aktAnw.lineNum);
                        this.doWait();
                    }
                    posAnw = aktAnw.geheZu;
                    break;
                }
                case 50: {
                    break;
                }
                case 2: {
                    break;
                }
                case 60: {
                    if (!this.runBedingung(aktAnw) || this.isStopped) break;
                    posAnw = aktAnw.geheZu - 1;
                    break;
                }
                case 61: {
                    if (this.runBedingung(aktAnw) || this.isStopped) break;
                    posAnw = aktAnw.geheZu - 1;
                    break;
                }
                case 6: {
                    if (this.runBedingung(aktAnw) || this.isStopped) break;
                    posAnw = aktAnw.geheZu;
                    break;
                }
                case 7: {
                    bTemp = this.runBedingung(aktAnw);
                    if (!bTemp && !this.isStopped) {
                        posAnw = aktAnw.geheZu;
                    }
                    if (!bTemp || this.isStopped) break;
                    this.runBereich(posAnw + 1, aktAnw.geheZu - 1, blockNr);
                    posAnw = this.anwArray.get((int)aktAnw.geheZu).geheZu;
                    break;
                }
                case 8: {
                    break;
                }
            }
            if (aktAnw.schluesselNr > 300 && aktAnw.schluesselNr < 400) {
                anwBlock = this.blockArray.get(aktAnw.schluesselNr - 300);
                this.runBereich(anwBlock.beginn + 1, anwBlock.ende - 1, aktAnw.schluesselNr - 300);
            }
            if (!this.karol.getFehlerText().isEmpty() && (this.stopOnError || this.showOnError)) {
                this.RunErrorProc(aktAnw.lineNum, this.stopOnError);
                this.isStopped = this.stopOnError;
            }
            if (!this.isFast) {
                this.view.ansichtAktualisieren(this.karol);
            }
            this.doDelay();
            if (this.progThread.isInterrupted()) {
                this.isStopped = true;
            }
            ++posAnw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doProgRunNormal() {
        if (this.progStatus == ProgStatusType.PStNothing) {
            this.pauseProgStatus = null;
            this.runProgramm(ProgStatusType.PStRunning);
        }
        if (this.progStatus == ProgStatusType.PStTracing) {
            this.progStatus = ProgStatusType.PStRunning;
            this.pauseProgStatus = null;
            this.view.ProgrammLampeSchalten(this.progStatus);
            if (this.progThread != null && this.progThread.isAlive()) {
                ProgThread progThread = this.progThread;
                synchronized (progThread) {
                    this.progThread.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doProgRunFast() {
        if (this.progStatus == ProgStatusType.PStNothing) {
            this.pauseProgStatus = null;
            this.runProgramm(ProgStatusType.PStRunningFast);
        }
        if (this.progStatus == ProgStatusType.PStTracing) {
            this.progStatus = ProgStatusType.PStRunningFast;
            this.pauseProgStatus = null;
            this.view.ProgrammLampeSchalten(this.progStatus);
            if (this.progThread != null && this.progThread.isAlive()) {
                ProgThread progThread = this.progThread;
                synchronized (progThread) {
                    this.progThread.notify();
                }
            }
        }
    }

    private void scrollProgrammVorbereiten() {
        JScrollBar vSB = this.view.getScrollBoxProgramm().getVerticalScrollBar();
        this.progScrollPerLine = (float)(vSB.getMaximum() - vSB.getVisibleAmount()) / (float)this.doc.getLineCount();
    }

    private void scrollProgrammText() {
        if (this.progScrollPerLine > 0.0f) {
            int tmLine = this.view.getGutterPanel().getTraceMarkerLine();
            JViewport vPort = this.view.getScrollBoxProgramm().getViewport();
            int tmpScrollMode = vPort.getScrollMode();
            vPort.setScrollMode(0);
            this.view.getScrollBoxProgramm().getVerticalScrollBar().setValue(Math.round(this.progScrollPerLine * (float)tmLine));
            vPort.setScrollMode(tmpScrollMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doProgStepByStep() {
        if (this.progStatus == ProgStatusType.PStNothing) {
            this.scrollProgrammVorbereiten();
            this.runProgramm(ProgStatusType.PStTracing);
            return;
        }
        if (this.progStatus == ProgStatusType.PStTracing && this.progThread != null && this.progThread.isAlive()) {
            ProgThread progThread = this.progThread;
            synchronized (progThread) {
                this.progThread.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doProgPause() {
        if (this.pauseProgStatus == null) {
            if (this.progStatus == ProgStatusType.PStRunning || this.progStatus == ProgStatusType.PStRunningFast) {
                this.pauseProgStatus = this.progStatus;
                this.progStatus = ProgStatusType.PStTracing;
                this.view.ProgrammLampeSchalten(this.progStatus);
            }
        } else {
            this.progStatus = this.pauseProgStatus;
            this.pauseProgStatus = null;
            this.view.ProgrammLampeSchalten(this.progStatus);
            if (this.progThread != null && this.progThread.isAlive()) {
                ProgThread progThread = this.progThread;
                synchronized (progThread) {
                    this.progThread.notify();
                }
            }
        }
    }

    public void doProgStopp() {
        this.isStopped = true;
        this.isFast = false;
        if (this.progThread != null && this.progThread.isAlive()) {
            this.progThread.interrupt();
        }
        this.progStatus = ProgStatusType.PStNothing;
    }

    public void RunErrorProc(int lnr, boolean stop) {
        String errorStr = null;
        if (stop) {
            errorStr = "[Abbruch][Zeile " + String.valueOf(lnr) + "]: Karol " + this.karol.getFehlerText() + "\n";
            this.view.InfoBoxHinzufuegen(5, errorStr);
            this.view.getGutterPanel().setMarkerToLine(KEdtGutter.MarkerType.BREAK, lnr);
        } else {
            errorStr = "[Hinweis]: Karol " + this.karol.getFehlerText() + "\n";
            this.view.InfoBoxHinzufuegen(errorStr);
        }
        this.karol.clearFehlerText();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$karoleditor$KEdtToken$TokenType() {
        if ($SWITCH_TABLE$karoleditor$KEdtToken$TokenType != null) {
            return $SWITCH_TABLE$karoleditor$KEdtToken$TokenType;
        }
        int[] nArray = new int[KEdtToken.TokenType.values().length];
        try {
            nArray[KEdtToken.TokenType.COMMENT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KEdtToken.TokenType.DEFAULT.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KEdtToken.TokenType.FILENAME.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KEdtToken.TokenType.IDENTIFIER.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KEdtToken.TokenType.KAROL.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KEdtToken.TokenType.KEY.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KEdtToken.TokenType.KEYANW.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KEdtToken.TokenType.KEYBED.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KEdtToken.TokenType.KEYEND.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KEdtToken.TokenType.LIB.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KEdtToken.TokenType.LIBEND.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KEdtToken.TokenType.NUMBER.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KEdtToken.TokenType.PCOLOR.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KEdtToken.TokenType.PEMPTY.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[KEdtToken.TokenType.PNUMBER.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$karoleditor$KEdtToken$TokenType = nArray;
        return nArray;
    }

    class KarolProgAnw {
        int schluesselNr;
        int bedNr;
        int paramI;
        boolean paramB;
        int geheZu;
        int lineNum;

        public KarolProgAnw() {
            this.schluesselNr = 0;
            this.bedNr = 0;
            this.paramI = 0;
            this.paramB = false;
            this.geheZu = 0;
            this.lineNum = 0;
        }

        public KarolProgAnw(int snr, int bnr, int pi, boolean pb, int gz, int ln) {
            this.schluesselNr = snr;
            this.bedNr = bnr;
            this.paramI = pi;
            this.paramB = pb;
            this.geheZu = gz;
            this.lineNum = ln;
        }

        public void reset() {
            this.schluesselNr = 0;
            this.bedNr = 0;
            this.paramI = 0;
            this.paramB = false;
            this.geheZu = 0;
            this.lineNum = 0;
        }

        public String toString() {
            String ergeb = null;
            ergeb = "Key " + this.schluesselNr + "; Bed " + this.bedNr + "; ParI " + this.paramI + "; ParB " + this.paramB + "; Gehe " + this.geheZu + " ;Zeile " + this.lineNum;
            return ergeb;
        }
    }

    class KarolProgBlock {
        byte typ;
        String bezeichner;
        int beginn;
        int ende;
        boolean result;

        public KarolProgBlock() {
            this.typ = 0;
            this.bezeichner = "";
            this.beginn = 0;
            this.ende = 0;
            this.result = false;
        }

        public KarolProgBlock(byte ty, String bz, int be, int en) {
            this.typ = ty;
            this.bezeichner = bz;
            this.beginn = be;
            this.ende = en;
            this.result = false;
        }
    }

    class KarolProgStack {
        int schluesselNr;
        int anwArrayIndex;

        public KarolProgStack() {
            this.schluesselNr = 0;
            this.anwArrayIndex = 0;
        }

        public KarolProgStack(int snr, int ind) {
            this.schluesselNr = snr;
            this.anwArrayIndex = ind;
        }

        public String toString() {
            String ergeb = null;
            ergeb = "Key " + this.schluesselNr + "; anwArrayIndex " + this.anwArrayIndex;
            return ergeb;
        }
    }

    public static enum ProgStatusType {
        PStNothing,
        PStRunning,
        PStRunningFast,
        PStTracing,
        PStStop;

    }

    class ProgThread
    extends Thread {
        ProgStatusType prgStat;

        public ProgThread() {
            super("KarolProgramm");
        }

        @Override
        public void run() {
            int startAnw = KarolProgram.this.blockArray.get((int)0).beginn;
            int endAnw = KarolProgram.this.blockArray.get((int)0).ende;
            KarolProgram.this.runBereich(startAnw, endAnw, 0);
            if (KarolProgram.this.isStopped) {
                KarolProgram.this.progStatus = ProgStatusType.PStNothing;
                KarolProgram.this.view.ProgrammLampeSchalten(ProgStatusType.PStNothing);
                KarolProgram.this.view.getGutterPanel().setMarkerInvisible(KEdtGutter.MarkerType.TRACE);
                KarolProgram.this.view.InfoBoxHinzufuegen(6, "Programmabbruch\n");
            } else {
                KarolProgram.this.view.ProgrammLampeSchalten(ProgStatusType.PStNothing);
                KarolProgram.this.view.getGutterPanel().setAllMarkerInvisible();
                KarolProgram.this.view.InfoBoxLoeschen();
                KarolProgram.this.view.InfoBoxHinzufuegen(6, "Programmende\n");
                KarolProgram.this.progStatus = ProgStatusType.PStNothing;
            }
        }
    }
}

