/*
 * Decompiled with CFR 0.152.
 */
package robotkarol;

import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import robotkarol.KarolProgram;

public class KarolTreeView {
    public JTree tree = null;
    private KarolProgram prog = null;
    private ImageIcon[] treeImage = new ImageIcon[8];

    public KarolTreeView(KarolProgram pro) {
        this.prog = pro;
        this.treeImage[0] = new ImageIcon(KarolTreeView.class.getResource("/icons/code_view_pfeil.gif"));
        this.treeImage[1] = new ImageIcon(KarolTreeView.class.getResource("/icons/code_view_grau.gif"));
        this.treeImage[2] = new ImageIcon(KarolTreeView.class.getResource("/icons/code_view_sdef.gif"));
        this.treeImage[3] = new ImageIcon(KarolTreeView.class.getResource("/icons/code_view_prog.gif"));
        this.treeImage[4] = new ImageIcon(KarolTreeView.class.getResource("/icons/code_view_lila.gif"));
        this.treeImage[5] = new ImageIcon(KarolTreeView.class.getResource("/icons/code_view_blau.gif"));
        this.treeImage[6] = new ImageIcon(KarolTreeView.class.getResource("/icons/code_view_gruen.gif"));
        this.treeImage[7] = new ImageIcon(KarolTreeView.class.getResource("/icons/code_view_empty.gif"));
    }

    private boolean between(int x, int a, int b) {
        return a <= x && x <= b;
    }

    private void buildControls(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode pNode = new DefaultMutableTreeNode(new treeKnoten("Kontrollstrukturen", 0));
        top.add(pNode);
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("wiederhole immer ANW endewiederhole", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("wiederhole n mal ANW endewiederhole", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("wiederhole solange BED endewiederhole", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("wiederhole ANW endewiederhole bis BED", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("wiederhole ANW endewiederhole solange BED", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("wenn BED dann ANW endewenn", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("wenn BED dann ANW sonst ANW endewenn", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("Anweisung ANW endeAnweisung", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("Methode ANW endeMethode", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("Bedingung ANW endeBedingung", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("Programm ANW endeProgramm", 1)));
    }

    private void buildCommands(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode pNode = new DefaultMutableTreeNode(new treeKnoten("Vordefinierte Anweisungen", 0));
        top.add(pNode);
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("Schritt", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("Schritt(ANZAHL)", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("LinksDrehen", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("RechtsDrehen", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("Hinlegen", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("Hinlegen(ANZAHL)", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("Hinlegen(FARBE)", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("Aufheben", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("Aufheben(ANZAHL)", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("MarkeSetzen", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("MarkeSetzen(FARBE)", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("MarkeL\u00f6schen", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("Warten", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("Warten(mSEK)", 1)));
        int i = 109;
        while (i <= 112) {
            pNode.add(new DefaultMutableTreeNode(new treeKnoten(this.prog.TokenMap.get(i), 1)));
            ++i;
        }
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("FARBE=rot,gelb,blau,gr\u00fcn", 1)));
    }

    private void buildConditions(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode pNode = new DefaultMutableTreeNode(new treeKnoten("Vordefinierte Bedingungen", 0));
        top.add(pNode);
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("IstWand", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("NichtIstWand", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("IstZiegel", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("IstZiegel(ANZAHL)", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("IstZiegel(FARBE)", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("NichtIstZiegel", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("NichtIstZiegel(ANZAHL)", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("NichtIstZiegel(FARBE)", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("IstMarke", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("IstMarke(FARBE)", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("NichtIstMarke", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("NichtIstMarke(FARBE)", 1)));
        int i = 207;
        while (i <= 215) {
            pNode.add(new DefaultMutableTreeNode(new treeKnoten(this.prog.TokenMap.get(i), 1)));
            ++i;
        }
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("HatZiegel(ANZAHL)", 1)));
        pNode.add(new DefaultMutableTreeNode(new treeKnoten("FARBE=rot,gelb,blau,gr\u00fcn", 1)));
    }

    private void buildBlocks(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode pNode = new DefaultMutableTreeNode(new treeKnoten("Eigene Anweisungen/Bedingungen", 2));
        top.add(pNode);
        int b = 1;
        while (b < this.prog.blockArray.size()) {
            KarolProgram.KarolProgBlock aktBlock = this.prog.blockArray.get(b);
            pNode.add(new DefaultMutableTreeNode(new treeKnoten(String.valueOf(aktBlock.bezeichner) + "()", 1)));
            ++b;
        }
        if (this.prog.blockArray.size() <= 1) {
            pNode.add(new DefaultMutableTreeNode(new treeKnoten("keine", 1)));
        }
    }

    private String bedingungStr(KarolProgram.KarolProgAnw aktAnw) {
        String ergebStr = "";
        String tempStr = "";
        if (aktAnw.paramB) {
            ergebStr = String.valueOf(this.prog.TokenMap.get(13)) + " ";
        }
        if (this.between(aktAnw.bedNr, 201, 215)) {
            if (aktAnw.paramI > 1) {
                tempStr = "(" + Integer.toString(aktAnw.paramI) + ")";
            }
            if (aktAnw.paramI < 0) {
                tempStr = this.prog.farbParameter[Math.abs(aktAnw.paramI) - 1];
            }
            ergebStr = String.valueOf(ergebStr) + this.prog.TokenMap.get(aktAnw.bedNr) + tempStr;
        }
        if (this.between(aktAnw.bedNr, 401, 499)) {
            ergebStr = String.valueOf(ergebStr) + this.prog.blockArray.get((int)(aktAnw.bedNr - 400)).bezeichner + "()";
        }
        return ergebStr;
    }

    private void buildBereich(int startAnw, int endAnw, DefaultMutableTreeNode top) {
        int posAnw = startAnw;
        KarolProgram.KarolProgAnw aktAnw = null;
        KarolProgram.KarolProgAnw sonstAnw = null;
        KarolProgram.KarolProgAnw nextAnw = null;
        String tempStr = "";
        while (posAnw <= endAnw && posAnw < this.prog.anwArray.size()) {
            DefaultMutableTreeNode pNode;
            aktAnw = this.prog.anwArray.get(posAnw);
            if (this.between(aktAnw.schluesselNr, 101, 112)) {
                tempStr = "";
                if (aktAnw.paramI > 1) {
                    tempStr = "(" + Integer.toString(aktAnw.paramI) + ")";
                }
                if (aktAnw.paramI < 0) {
                    tempStr = this.prog.farbParameter[Math.abs(aktAnw.paramI) - 1];
                }
                tempStr = String.valueOf(this.prog.TokenMap.get(aktAnw.schluesselNr)) + tempStr;
                top.add(new DefaultMutableTreeNode(new treeKnoten(tempStr, 5)));
            }
            if (this.between(aktAnw.schluesselNr, 11, 12)) {
                tempStr = this.prog.TokenMap.get(aktAnw.schluesselNr);
                top.add(new DefaultMutableTreeNode(new treeKnoten(tempStr, 5)));
            }
            if (this.between(aktAnw.schluesselNr, 301, 399)) {
                tempStr = this.prog.blockArray.get((int)(aktAnw.schluesselNr - 300)).bezeichner;
                top.add(new DefaultMutableTreeNode(new treeKnoten(String.valueOf(tempStr) + "()", 6)));
            }
            if (this.between(aktAnw.schluesselNr, 3, 5)) {
                tempStr = String.valueOf(this.prog.TokenMap.get(2)) + " ";
                if (aktAnw.schluesselNr == 3) {
                    tempStr = String.valueOf(tempStr) + Integer.toString(aktAnw.paramI) + " " + this.prog.TokenMap.get(3);
                }
                if (aktAnw.schluesselNr == 5) {
                    tempStr = String.valueOf(tempStr) + this.prog.TokenMap.get(16);
                }
                if (aktAnw.schluesselNr == 4) {
                    tempStr = String.valueOf(tempStr) + this.prog.TokenMap.get(4) + " " + this.bedingungStr(aktAnw);
                }
                pNode = new DefaultMutableTreeNode(new treeKnoten(tempStr, 1));
                top.add(pNode);
                this.buildBereich(posAnw + 1, aktAnw.geheZu, pNode);
                posAnw = aktAnw.geheZu;
            }
            if (aktAnw.schluesselNr == 2) {
                pNode = new DefaultMutableTreeNode(new treeKnoten(this.prog.TokenMap.get(4), 1));
                top.add(pNode);
                this.buildBereich(posAnw + 1, aktAnw.geheZu, pNode);
                nextAnw = this.prog.anwArray.get(aktAnw.geheZu);
                tempStr = String.valueOf(this.prog.TokenMap.get(2)) + " ";
                if (nextAnw.schluesselNr == 60) {
                    tempStr = String.valueOf(tempStr) + this.prog.TokenMap.get(4) + this.bedingungStr(nextAnw);
                }
                if (nextAnw.schluesselNr == 61) {
                    tempStr = String.valueOf(tempStr) + this.prog.TokenMap.get(4) + this.bedingungStr(nextAnw);
                }
                pNode.add(new DefaultMutableTreeNode(new treeKnoten(tempStr, 7)));
                posAnw = aktAnw.geheZu;
            }
            if (aktAnw.schluesselNr == 6) {
                tempStr = String.valueOf(this.prog.TokenMap.get(6)) + " " + this.bedingungStr(aktAnw) + " " + this.prog.TokenMap.get(7);
                pNode = new DefaultMutableTreeNode(new treeKnoten(tempStr, 1));
                top.add(pNode);
                this.buildBereich(posAnw + 1, aktAnw.geheZu, pNode);
                posAnw = aktAnw.geheZu;
            }
            if (aktAnw.schluesselNr == 7) {
                tempStr = String.valueOf(this.prog.TokenMap.get(6)) + " " + this.bedingungStr(aktAnw) + " " + this.prog.TokenMap.get(7);
                pNode = new DefaultMutableTreeNode(new treeKnoten(tempStr, 1));
                top.add(pNode);
                this.buildBereich(posAnw + 1, aktAnw.geheZu, pNode);
                posAnw = aktAnw.geheZu;
                sonstAnw = this.prog.anwArray.get(posAnw);
                tempStr = this.prog.TokenMap.get(8);
                DefaultMutableTreeNode p2Node = new DefaultMutableTreeNode(new treeKnoten(tempStr, 1));
                top.add(p2Node);
                this.buildBereich(posAnw + 1, sonstAnw.geheZu, p2Node);
                posAnw = sonstAnw.geheZu;
            }
            ++posAnw;
        }
    }

    private void buildProgram(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode pNode = new DefaultMutableTreeNode(new treeKnoten("Dieses Programm", 3));
        top.add(pNode);
        int b = 0;
        while (b < this.prog.blockArray.size()) {
            KarolProgram.KarolProgBlock aktBlock = this.prog.blockArray.get(b);
            DefaultMutableTreeNode p2Node = b == 0 ? new DefaultMutableTreeNode(new treeKnoten("Programm()", 4)) : new DefaultMutableTreeNode(new treeKnoten(String.valueOf(aktBlock.bezeichner) + "()", 4));
            pNode.add(p2Node);
            this.buildBereich(this.prog.blockArray.get((int)b).beginn, this.prog.blockArray.get((int)b).ende, p2Node);
            ++b;
        }
        if (this.prog.blockArray.size() <= 0) {
            pNode.add(new DefaultMutableTreeNode(new treeKnoten("kein Programm", 1)));
        }
    }

    public JTree buildCodeTree(boolean mitProg) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new treeKnoten("CodeView", -1));
        this.buildControls(root);
        this.buildCommands(root);
        this.buildConditions(root);
        if (mitProg) {
            this.buildBlocks(root);
            this.buildProgram(root);
        }
        this.tree = new JTree(root);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setFont(new Font("Arial", 0, 12));
        KarolTreeCellRenderer renderer = new KarolTreeCellRenderer();
        this.tree.setCellRenderer(renderer);
        return this.tree;
    }

    class KarolTreeCellRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            treeKnoten nodeObj = (treeKnoten)node.getUserObject();
            int nr = nodeObj.iconNr;
            if (KarolTreeView.this.between(nr, 0, 7)) {
                this.setIcon(KarolTreeView.this.treeImage[nr]);
            }
            return this;
        }
    }

    private class treeKnoten {
        String textStr = "";
        int iconNr = 0;

        treeKnoten(String name, int icon) {
            this.textStr = name;
            this.iconNr = icon;
        }

        public String toString() {
            return this.textStr;
        }
    }
}

